﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief PSM ライブラリの生産工程用の型の宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace psm {

/**
 * @brief 給電経路
 */
enum SupplyRoute
{
    SupplyRoute_Invalid, //!< 無効な給電経路
    SupplyRoute_None,    //!< 給電経路非接続
    SupplyRoute_Vdd50A,  //!< 給電経路 VDD50A
    SupplyRoute_Vdd50B,  //!< 給電経路 VDD50B
};

}} // namespace nn::psm
