﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/psc/psc_Types.h>
#include <nn/psc/psc_PmModuleId.h>

namespace nn {
namespace psc {
namespace util {

struct TransitionInformation
{
    int64_t startTick;
    int64_t endTick;
    uint32_t result;
    PmState previousState;
    PmState currentState;
};

struct ModuleTransitionInformation
{
    int64_t startTick;
    int64_t endTick;
    int32_t level;
    PmModuleId id;
    PmState currentState;
    PmState nextState;
    bool initialized;
};

struct DependencyInformation
{
    PmModuleId sourceId;
    PmModuleId destinationId;
};

const char* GetStateNameString(nn::psc::PmState state) NN_NOEXCEPT;
const char* GetModuleNameString(nn::psc::PmModuleId id) NN_NOEXCEPT;

void PrintModuleInformation(
    TransitionInformation& transitionInfo,
    int moduleCount,
    ModuleTransitionInformation moduleInfoList[],
    int dependencyCount,
    DependencyInformation dependencyInfoList[]
    ) NN_NOEXCEPT;

}}}
