﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
    @file
*/

#pragma once

#include <nn/psc/psc_PmModuleId.h>

namespace nn  {
namespace psc {

#define NN_DETAIL_PSC_REQUIRED_MODULE_ID_LIST_FOR_MAINTENANCE_MODE \
    PmModuleId_Socket, \
    PmModuleId_Usb, \
    PmModuleId_Eth, \
    PmModuleId_Fgm, \
    PmModuleId_PcvClock, \
    PmModuleId_PcvVoltage, \
    PmModuleId_Gpio, \
    PmModuleId_Pinmux, \
    PmModuleId_Uart, \
    PmModuleId_I2c, \
    PmModuleId_I2cPowerBus, \
    PmModuleId_Pwm, \
    PmModuleId_Psm, \
    PmModuleId_Tc, \
    PmModuleId_Pcie, \
    PmModuleId_Lbl, \
    PmModuleId_Display, \
    PmModuleId_Hid, \
    PmModuleId_SocketWlan, \
    /* PmModuleId_Wlan,*/ \
    PmModuleId_Fs, \
    PmModuleId_Audio, \
    PmModuleId_Bluetooth, \
    PmModuleId_Bpc, \
    PmModuleId_Fan, \
    PmModuleId_Apm, \
    PmModuleId_Btm, \
    PmModuleId_Nifm, \
    PmModuleId_GpioLow, \
    PmModuleId_Lm, \
    PmModuleId_NvHost, \
    PmModuleId_Time, \
    PmModuleId_Account, \
    PmModuleId_Nfc, \
    PmModuleId_Sasbus, \
    PmModuleId_PsmLow

#define NN_DETAIL_PSC_REQUIRED_MODULE_ID_LIST_ONLY_FOR_NORMAL_MODE \
    PmModuleId_Bcat, \
    PmModuleId_Npns, \
    PmModuleId_Friends

/**
    @brief
       Required PSC modules for maintenance mode.
*/
const PmModuleId RequiredPmModuleIdListForMaintenanceMode[] = {
    NN_DETAIL_PSC_REQUIRED_MODULE_ID_LIST_FOR_MAINTENANCE_MODE
};

/**
    @brief
        Required PSC modules for normal mode.
*/
const PmModuleId RequiredPmModuleIdListForNormalMode[] = {
    NN_DETAIL_PSC_REQUIRED_MODULE_ID_LIST_FOR_MAINTENANCE_MODE,
    NN_DETAIL_PSC_REQUIRED_MODULE_ID_LIST_ONLY_FOR_NORMAL_MODE
};

}}


