﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/prepo/prepo_TypesDebug.h>

namespace nn { namespace prepo {

/*!
    @name   デバッグ
    @{
*/

/*!
    @brief      ストレージの使用状況を取得します。（デバッグ用）

    @param[out] outUsed     使用済みのサイズ。
    @param[out] outCapacity ストレージ容量。

    @return     処理結果。

    @pre
        - outUsed != nullptr
        - outCapacity != nullptr
*/
nn::Result GetStorageUsage(int64_t* outUsed, int64_t* outCapacity) NN_NOEXCEPT;

/*!
    @brief      統計情報を取得します。（デバッグ用）

    @param[out] out 統計情報。

    @pre
        - out != nullptr
*/
void GetStatistics(Statistics* out) NN_NOEXCEPT;

/*!
    @brief      1 分あたりの Save API の呼び出し回数の履歴を取得します。

    @param[out] outCount    @a outArray に格納した個数。
    @param[out] outArray    履歴を格納した配列。
    @param[in]  arrayCount  @a outArray の要素数。

    @pre
        - outCount != nullptr
        - outArray != nullptr
        - arrayCount > 0

    @details
                outArray には、最近の履歴から順に格納されます。
                つまり、outArray[0] には現在から 1 分前までの呼び出し回数、
                outArray[2] には 1 分前から 2 分前までの呼び出し回数が格納されます。

                最大で、過去一時間分の履歴を取得できます。
*/
void GetThroughputHistory(int* outCount, ThroughputRecord* outArray, int arrayCount) NN_NOEXCEPT;

/*!
    @brief      最後に発生した送信時のエラーを取得します。（デバッグ用）

    @return     最後に発生した送信時のエラー。
*/
nn::Result GetLastUploadError() NN_NOEXCEPT;

/*!
    @}
*/

}}
