﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/prepo/prepo_Types.h>

namespace nn { namespace prepo {

/*!
    @name   ストレージ管理
    @{
*/

/*!
    @brief      レポートデータの保存ストレージをクリアします。

    @return     処理結果。

    @details
                未送信のレポートデータをすべて削除します。
*/
nn::Result ClearStorage() NN_NOEXCEPT;

/*!
    @}
    @name   統計情報
    @{
*/

/*!
    @brief      永続化された統計情報をクリアします。

    @return     処理結果。
*/
nn::Result ClearStatistics() NN_NOEXCEPT;

/*!
    @}
    @name   システム情報
    @{
*/

/*!
    @brief      現在の動作モードを設定します。

    @param[in]  mode    動作モード。
*/
void SetOperationMode(int64_t mode) NN_NOEXCEPT;

/*!
    @}
*/

}}
