﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/prepo/prepo_Types.h>

namespace nn { namespace prepo {

/*!
    @name   初期化
    @{
*/

/*!
    @brief      ライブラリの初期化を行います。

    @details
                本ライブラリの API はライブラリの初期化が行われていなかった場合、ライブラリの初期化を行います。@n
                ライブラリの初期化を事前に行うことで、アプリの設定に由来する初期化エラーを即座に検知できるようになります。

                本関数は複数回呼び出しても問題ありません。
*/
void Initialize() NN_NOEXCEPT;

/*!
    @}
    @name   送信要求
    @{
*/

/*!
    @brief      システムに保存されているレポートデータの即時送信要求を行います。

    @return     処理結果。

    @details
                本関数を呼び出した時点でシステムに保存されているレポートデータの即時送信要求を行います。@n
                本関数の呼び出し後に記録されたレポートデータは、即時送信の対象にはなりません。

    @see
        - PlayReport
*/
nn::Result RequestImmediateTransmission() NN_NOEXCEPT;

/*!
    @brief      転送状態を取得します。

    @param[out] outStatus   転送状態。

    @return     処理結果。

    @pre
        - outStatus != nullptr
*/
nn::Result GetTransmissionStatus(TransmissionStatus* outStatus) NN_NOEXCEPT;

/*!
    @}
*/

}}
