﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace prepo { namespace detail { namespace service { namespace util {

/*!
    @brief      日時文字列のヌル終端を含んだサイズです。
*/
const int DateTimeStringSize = sizeof ("YYYY-MM-DD hh:mm:ss");

/*!
    @brief      ユーザークロックの日時文字列を取得します。

    @param[in]  buffer      日時文字列を格納するバッファ。
    @param[in]  bufferSize  @a buffer のサイズ。

    @return     処理結果。

    @details
                日時文字列の書式は YYYY-MM-DD hh:mm:ss です。
*/
nn::Result GetCurrentUserTimeString(char* buffer, size_t bufferSize) NN_NOEXCEPT;

/*!
    @brief      ユーザークロックの日時文字列を取得します。

    @param[in]  buffer      日時文字列を格納するバッファ。
    @param[in]  bufferSize  @a buffer のサイズ。

    @return     処理結果。

    @details
                日時文字列の書式は YYYY-MM-DD hh:mm:ss です。
*/
nn::Result GetCurrentNetworkTimeString(char* buffer, size_t bufferSize) NN_NOEXCEPT;

}}}}}
