﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/prepo/prepo_Types.h>

namespace nn { namespace prepo { namespace detail { namespace service {

/*!
    @brief      レポートデータの概要です。
*/
struct ReportDataSummary
{
    size_t dataSize;    //!< ヘッダを含めたレポートデータのサイズ。
    size_t restSize;    //!< 残りのレポートの合計サイズ。
    int restCount;      //!< 残りのレポートの合計個数。
    size_t deletedSize; //!< 削除したレポートの合計サイズ。
    int deletedCount;   //!< 削除したレポートの合計個数。

    ReportDataSummary& operator+=(const ReportDataSummary& rhs) NN_NOEXCEPT
    {
        this->dataSize += rhs.dataSize;
        this->restSize += rhs.restSize;
        this->restCount += rhs.restCount;
        this->deletedSize += rhs.deletedSize;
        this->deletedCount += rhs.deletedCount;
        return *this;
    }
};

}}}}
