﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/sf_Types.h>
#include <nn/prepo/detail/ipc/prepo_IPrepoService.sfdl.h>

namespace nn { namespace prepo { namespace detail { namespace service {

/*!
    @brief      サービスの初期化を行います。

    @param[in]  index       インデックス。
    @param[in]  serviceName サービス名。
    @param[in]  capability  ケイパビリティフラグ。

    @pre
        - 0 <= index < detail::ipc::ServiceCount
*/
void InitializeService(int index, const char* serviceName, Bit32 capability) NN_NOEXCEPT;

/*!
    @brief      初期化済みのサービスすべての終了処理を行います。
*/
void FinalizeServices() NN_NOEXCEPT;

/*!
    @brief      PrepoService を取得します。

    @param[in]  index   インデックス。

    @return     PrepoService。

    @pre
        - 0 <= index < detail::ipc::ServiceCount

    @details
                指定したインデックスのサービスは事前に作成しておく必要があります。
*/
nn::sf::SharedPointer<detail::ipc::IPrepoService> GetPrepoService(int index) NN_NOEXCEPT;

}}}}
