﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Types.h>

namespace nn { namespace prepo { namespace detail { namespace service { namespace core {

/*!
    @brief      ユーザーを管理するクラスです。

    @attention
                本体上の最大のユーザー数までしか管理できません。
                最大のユーザー数を超えるユーザーが追加されたときは、本体に存在しないユーザーを
                管理対象から外して追加します。
*/
class UserManager
{
public:
    UserManager() NN_NOEXCEPT;
public:
    /*!
        @brief      指定されたユーザーを追加します。

        @param[in]  user    追加するユーザー。
    */
    void Add(const nn::account::Uid& user) NN_NOEXCEPT;

    /*!
        @brief      指定されたユーザーが追加されている場合、削除します。

        @param[in]  user    削除するユーザー。
    */
    void RemoveIfContains(const nn::account::Uid& user) NN_NOEXCEPT;

    /*!
        @brief      指定されたユーザーが追加されているか調べます。

        @param[in]  user    追加されているか調べるユーザー。

        @return     追加されているかいるとき true、されていないとき false。
    */
    bool Contains(const nn::account::Uid& user) NN_NOEXCEPT;

private:
    //
    bool TryAdd(const nn::account::Uid& user) NN_NOEXCEPT;
    //
    void RemoveInexistenceUser() NN_NOEXCEPT;

private:
    //
    nn::account::Uid m_Users[nn::account::UserCountMax];

};

}}}}}
