﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/prepo/detail/service/prepo_Common.h>
#include <nn/dauth/dauth_Api.h>
#include <nn/dauth/dauth_Result.h>

namespace nn { namespace prepo { namespace detail { namespace service { namespace core {

/*!
    @brief      デバイス認証トークンを管理するクラスです。
*/
class DeviceAuthenticationToken
{
private:
    NN_DISALLOW_COPY(DeviceAuthenticationToken);
    NN_DISALLOW_MOVE(DeviceAuthenticationToken);

private:
    /*!
        @brief      コンストラクタです。
    */
    DeviceAuthenticationToken() NN_NOEXCEPT;

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static DeviceAuthenticationToken& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(DeviceAuthenticationToken, s_Instance);
        return s_Instance;
    }


public:
    /*!
        @brief      デバイス認証トークンを取得します。

        @param[in]  pOutToken   デバイス認証トークンのポインタを格納するポインタ。
        @param[in]  forceUpdate 強制的に、デバイス認証トークンを更新するか。

        @return     処理結果。

        @pre
            - pOutToken != nullptr

        @details
                    本関数は、シングルスレッド専用です。@n
                    本クラス内にキャッシュしている、デバイス認証トークンのポインタを返します。@n
                    デバイス認証トークンが未取得、および期限切れの場合は、デバイス認証トークンのダウンロード処理が実行されます。
    */
    nn::Result Get(const char** pOutToken, bool forceUpdate = false) NN_NOEXCEPT;

private:
    /*!
        @brief      認証トークンです。
    */
    char m_AuthToken[nn::dauth::RequiredBufferSizeForDeviceAuthenticationToken];
};

}}}}}
