﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace prepo { namespace detail { namespace ipc {

//// PrepoService

/*!
    @brief      1 プロセスあたりの PrepoService 数です。
*/
const int PrepoServiceCountPerProcess = 1;

/*!
    @brief      PrepoService を利用するプロセス同時接続数です。
*/
const int PrepoServiceProcessCountMax = 12;

/*!
    @brief      PrepoService の最大数です。

    @details
                1 つの PrepoServiceObject をすべてのプロセスでシェアするため、 1 でカウントされます。
*/
const int PrepoServiceCountMax = 1;

//// Session

/*!
    @brief      1 プロセスあたりのセッション数です。
*/
const int SessionCountPerProcess = 1;

/*!
    @brief      システムが提供するセッション数です。
*/
const int SessionCountMax = 12;

//// Object

/*!
    @brief      1 プロセスあたりのオブジェクト数です。
*/
const int ObjectCountPerProcess = PrepoServiceCountPerProcess;

}}}}
