﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      pl モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_PL_TRACE(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(pl, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_PL_TRACE_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pl, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_PL_TRACE_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pl, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_PL_TRACE_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pl, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_PL_INFO(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(pl, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_PL_INFO_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pl, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_PL_INFO_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pl, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_PL_INFO_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pl, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_PL_WARN(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(pl, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_PL_WARN_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pl, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_PL_WARN_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pl, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_PL_WARN_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pl, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_PL_ERROR(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(pl, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_PL_ERROR_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pl, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_PL_ERROR_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pl, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_PL_ERROR_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pl, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_PL_FATAL(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(pl, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_PL_FATAL_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pl, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_PL_FATAL_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pl, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_PL_FATAL_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pl, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_PL_VTRACE(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Trace, 0, format, args)
#define NN_DETAIL_PL_VTRACE_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Trace, 1, format, args)
#define NN_DETAIL_PL_VTRACE_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Trace, 2, format, args)
#define NN_DETAIL_PL_VTRACE_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Trace, 3, format, args)

#define NN_DETAIL_PL_VINFO(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Info, 0, format, args)
#define NN_DETAIL_PL_VINFO_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Info, 1, format, args)
#define NN_DETAIL_PL_VINFO_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Info, 2, format, args)
#define NN_DETAIL_PL_VINFO_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Info, 3, format, args)

#define NN_DETAIL_PL_VWARN(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Warn, 0, format, args)
#define NN_DETAIL_PL_VWARN_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Warn, 1, format, args)
#define NN_DETAIL_PL_VWARN_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Warn, 2, format, args)
#define NN_DETAIL_PL_VWARN_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Warn, 3, format, args)

#define NN_DETAIL_PL_VERROR(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Error, 0, format, args)
#define NN_DETAIL_PL_VERROR_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Error, 1, format, args)
#define NN_DETAIL_PL_VERROR_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Error, 2, format, args)
#define NN_DETAIL_PL_VERROR_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Error, 3, format, args)

#define NN_DETAIL_PL_VFATAL(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Fatal, 0, format, args)
#define NN_DETAIL_PL_VFATAL_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Fatal, 1, format, args)
#define NN_DETAIL_PL_VFATAL_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Fatal, 2, format, args)
#define NN_DETAIL_PL_VFATAL_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pl, Fatal, 3, format, args)

#define NN_DETAIL_PL_PUT_TRACE(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(pl, Trace, 0, text, length)
#define NN_DETAIL_PL_PUT_TRACE_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pl, Trace, 1, text, length)
#define NN_DETAIL_PL_PUT_TRACE_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pl, Trace, 2, text, length)
#define NN_DETAIL_PL_PUT_TRACE_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pl, Trace, 3, text, length)

#define NN_DETAIL_PL_PUT_INFO(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(pl, Info, 0, text, length)
#define NN_DETAIL_PL_PUT_INFO_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pl, Info, 1, text, length)
#define NN_DETAIL_PL_PUT_INFO_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pl, Info, 2, text, length)
#define NN_DETAIL_PL_PUT_INFO_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pl, Info, 3, text, length)

#define NN_DETAIL_PL_PUT_WARN(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(pl, Warn, 0, text, length)
#define NN_DETAIL_PL_PUT_WARN_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pl, Warn, 1, text, length)
#define NN_DETAIL_PL_PUT_WARN_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pl, Warn, 2, text, length)
#define NN_DETAIL_PL_PUT_WARN_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pl, Warn, 3, text, length)

#define NN_DETAIL_PL_PUT_ERROR(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(pl, Error, 0, text, length)
#define NN_DETAIL_PL_PUT_ERROR_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pl, Error, 1, text, length)
#define NN_DETAIL_PL_PUT_ERROR_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pl, Error, 2, text, length)
#define NN_DETAIL_PL_PUT_ERROR_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pl, Error, 3, text, length)

#define NN_DETAIL_PL_PUT_FATAL(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(pl, Fatal, 0, text, length)
#define NN_DETAIL_PL_PUT_FATAL_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pl, Fatal, 1, text, length)
#define NN_DETAIL_PL_PUT_FATAL_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pl, Fatal, 2, text, length)
#define NN_DETAIL_PL_PUT_FATAL_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pl, Fatal, 3, text, length)
