﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief header defining the O.S. dependencies for PerfLogger object.
*/


#if defined(NN_NINTENDO_SDK)
    // this case includes Siglo for Windows
    #define PERFLOG_PLATFORM_HORIZON
    #include <nn/os.h>
    #include <nn/nn_Macro.h>
    #include <nn/nn_TimeSpan.h>
    #include <nn/os/os_Tick.h>
    #include <nn/os/os_Macro.h>
    #include <nnc/os/os_TickTypes.h>
    #include <nn/os/os_ThreadApi.h>
    #include <nn/os/os_ThreadTypes.h>
#elif defined(_WIN32)
    // this is NOT Siglo For Windows. this is pure Windows
    #include <windows.h>
    #define PERFLOG_PLATFORM_WINDOWS
#else
    #define PERFLOG_PLATFORM_UNIX
    #include <pthread.h>
    #include <ctime>
#endif


#if defined(NN_NINTENDO_SDK) || defined(_MSC_VER)
#define USE_ATOMIC
#endif

#if defined(USE_ATOMIC)
#include <atomic>  // std::atomic
#endif




namespace nn
{

namespace perflog
{

#if defined(PERFLOG_PLATFORM_HORIZON)
    typedef nnosTick                 OSRawTimestamp;
    typedef nn::os::ThreadType*      OSThreadId;
    typedef nn::os::ThreadType       OSThread;
    typedef uint64_t                 HWTickFrequency;
    typedef nn::os::SystemEventType  OSEvent;
    #define OSInvalidThread          {0,}
    #define OSInvalidEvent           {0,}
#elif defined(PERFLOG_PLATFORM_WINDOWS)
    typedef LARGE_INTEGER            OSRawTimestamp;
    typedef DWORD                    OSThreadId;
    typedef HANDLE                   OSThread;
    typedef LARGE_INTEGER            HWTickFrequency;
    typedef HANDLE                   OSEvent;
    #define OSInvalidThread          NULL
    #define OSInvalidEvent           NULL
#else
    typedef struct timespec          OSRawTimestamp;
    typedef pthread_t                OSThreadId;
    typedef pthread_t                OSThread;
    typedef uint64_t                 HWTickFrequency;
    typedef int                      OSEvent;
    enum OSInvalid
    {
        OSInvalidThread = 0,
        OSInvalidEvent  = (-1)
    };
#endif



// little portable shim library for O.S. abstractions
bool OSCreateThread( OSThread* pNewThread, uint32_t(*entryPoint)(void*), void *param );
bool OSCreateEvent ( OSEvent*  pNewEvent );
bool OSJoinThread  ( OSThread* pThr,  uint32_t timeoutMs, bool *pbTimedOut );
bool OSCloseThread ( OSThread* pThr );
bool OSWaitForEvent( OSEvent* pEvent, uint32_t timeoutMs, bool *pbTimedOut );
bool OSSignalEvent ( OSEvent* pEvent );
bool OSCloseEvent  ( OSEvent* pEvent );


} /* namespace perflog */


} /* namespace nn */




