﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account.h>
#include <nn/pdm/pdm_SystemTypes.h>
#include <nn/pdm/pdm_PrivateTypes.h>
#include <nn/pdm/detail/pdm_IQueryService.sfdl.h>
#include <nn/pdm/detail/pdm_QueryServiceHelper.h>

namespace nn { namespace pdm { namespace srv {

class QueryServiceImpl
{
public:
    NN_IMPLICIT QueryServiceImpl(pdm::detail::LockableMemoryBuffer* pLockableBuffer) NN_NOEXCEPT;
    nn::Result QueryApplicationEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::ApplicationEvent>& outList, std::int32_t eventIndexOffset) NN_NOEXCEPT;
    nn::Result QueryPlayStatistics(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayStatistics>& outList) NN_NOEXCEPT;
    nn::Result QueryPlayStatisticsByUserAccountId(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayStatistics>& outList, const nn::account::Uid& user) NN_NOEXCEPT;
    nn::Result QueryPlayStatisticsByNetworkServiceAccountId(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayStatistics>& outList, nn::account::NetworkServiceAccountId networkServiceAccountId) NN_NOEXCEPT;
    nn::Result QueryPlayStatisticsByApplicationId(nn::sf::Out<nn::pdm::PlayStatistics> outValue, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result QueryPlayStatisticsByApplicationIdAndUserAccountId(nn::sf::Out<nn::pdm::PlayStatistics> outValue, nn::ncm::ApplicationId applicationId, const nn::account::Uid& user) NN_NOEXCEPT;
    nn::Result QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId(nn::sf::Out<nn::pdm::PlayStatistics> outValue, nn::ncm::ApplicationId applicationId, nn::account::NetworkServiceAccountId networkServiceAccountId) NN_NOEXCEPT;
    nn::Result QueryLastPlayTime(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::LastPlayTime>& outList, const nn::sf::InArray<nn::ApplicationId>& applicationIdList) NN_NOEXCEPT;
    nn::Result QueryPlayEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayEvent>& outList, std::int32_t offset) NN_NOEXCEPT;
    nn::Result GetAvailablePlayEventRange(nn::sf::Out<std::int32_t> outCount, nn::sf::Out<std::int32_t> startIndex, nn::sf::Out<std::int32_t> lastIndex) NN_NOEXCEPT;
    nn::Result QueryAccountEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::AccountEvent>& outList, std::int32_t eventIndexOffset) NN_NOEXCEPT;
    nn::Result QueryAccountPlayEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::AccountPlayEvent>& outList, std::int32_t offset, const nn::account::Uid& user) NN_NOEXCEPT;
    nn::Result GetAvailableAccountPlayEventRange(nn::sf::Out<std::int32_t> outCount, nn::sf::Out<std::int32_t> startIndex, nn::sf::Out<std::int32_t> lastIndex, const nn::account::Uid& user) NN_NOEXCEPT;
    nn::Result QueryApplicationPlayStatisticsForSystem(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::ApplicationPlayStatistics>& outList, const nn::sf::InArray<nn::ncm::ApplicationId>& applicationIdList) NN_NOEXCEPT;
    nn::Result QueryRecentlyPlayedApplication(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ApplicationId>& outList, const nn::account::Uid& user) NN_NOEXCEPT;
    nn::Result GetRecentlyPlayedApplicationUpdateEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT;
private:
    pdm::detail::LockableMemoryBuffer* const m_pLockableBuffer;
    pdm::PlayEvent* const m_PlayEventReadBuffer;
    const int m_PlayEventReadBufferCount;
};

}}}
