﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account.h>
#include <nn/pdm/pdm_SystemTypes.h>
#include <nn/pdm/detail/pdm_PlayEventBuffer.h>
#include <nn/pdm/detail/pdm_INotifyService.sfdl.h>

namespace nn { namespace pdm { namespace srv {

class NotifyServiceImpl
{
public:
    nn::Result NotifyAppletEvent(nn::pdm::AppletEventType eventType, nn::ncm::ProgramId programId, std::uint32_t version, std::uint8_t appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy) NN_NOEXCEPT;
    nn::Result NotifyOperationModeChangeEvent(nn::pdm::OperationMode eventType) NN_NOEXCEPT;
    nn::Result NotifyPowerStateChangeEvent(nn::pdm::PowerStateChangeEventType eventType) NN_NOEXCEPT;
    nn::Result NotifyClearAllEvent() NN_NOEXCEPT;
    nn::Result NotifyEventForDebug(const nn::sf::InArray<nn::pdm::PlayEvent>& playEventArray) NN_NOEXCEPT;
    nn::Result SuspendUserAccountEventService(const account::Uid& user) NN_NOEXCEPT;
    nn::Result ResumeUserAccountEventService(const account::Uid& user) NN_NOEXCEPT;
    nn::Result NotifyLibraryAppletEvent(nn::pdm::AppletEventType eventType, nn::ncm::ProgramId mainProgramId, std::uint8_t libraryAppletMode, std::uint8_t appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy) NN_NOEXCEPT;
};

}}}
