﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_ApplicationId.h>

namespace nn { namespace pdm {

/**
* @brief    アプリケーションを最後に遊んだ時刻に関する情報です。
*/
struct LastPlayTime
{
    nn::ApplicationId   applicationId;              //!< アプリケーションID
    uint32_t            userClockTime;              //!< ユーザー時計時刻（nn::time::InputPosixTimeMin からの経過分）
    uint32_t            networkClockTime;           //!< ネットワーク時計時刻（nn::time::InputPosixTimeMin からの経過分）。ネットワーク時計が無効な場合は 0。
    uint32_t            elapsedMinutesSinceLastPlay;//!< 単調増加時計から計算した、最後に遊んでからの経過時間（分）。isElapsedMinutesAvailable が false の場合、この値は無効。
    bool                isElapsedMinutesAvailable;  //!< 最後に遊んでからの経過時間が有効かどうかのフラグ。対象のアプリケーションを最後に遊んでから単調増加時計のリセットがあった場合に無効になります。
};

/**
* @brief        アプリケーションを最後に遊んだ時刻に関する情報を取得します。
* @param[out]   outValue 最後に遊んだ時刻に関する情報
* @param[in]    applicationIds 最後に遊んだ時刻を取得するアプリケーションのIDのリスト
* @param[in]    count outValue, applicationIds の要素数
* @return       outValue に格納された有効な情報の数。
* @details      有効な情報が取得できた場合、outValue[index].applicationId == applicationIds[index] となります。
*               outValue[index].applicationId == GetInvalidId() だった場合、applicationIds[index] の情報の取得に失敗したことを表します。
*/
int QueryLastPlayTime(LastPlayTime outValue[], const nn::ApplicationId applicationIds[], int count) NN_NOEXCEPT;

}}
