﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief  PlayDataManager にイベントの発生を通知するためのデバッグ用の API を定義します。
 */

#include <nn/pdm/pdm_PrivateTypes.h>

namespace nn { namespace pdm {

/**
* @brief        イベントを直接通知します（デバッグ用）
* @param[in]    playEvent 通知するイベント。
* @param[in]    count playEvent の数。
*/
void NotifyEventForDebug(const PlayEvent playEvent[], int count) NN_NOEXCEPT;

}}
