﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      pdm モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_PDM_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_PDM_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_PDM_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_PDM_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_PDM_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_PDM_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_PDM_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_PDM_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_PDM_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_PDM_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_PDM_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_PDM_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_PDM_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_PDM_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_PDM_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_PDM_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_PDM_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_PDM_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_PDM_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_PDM_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pdm, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_PDM_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Trace, 0, format, args)
#define NN_DETAIL_PDM_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Trace, 1, format, args)
#define NN_DETAIL_PDM_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Trace, 2, format, args)
#define NN_DETAIL_PDM_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Trace, 3, format, args)

#define NN_DETAIL_PDM_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Info, 0, format, args)
#define NN_DETAIL_PDM_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Info, 1, format, args)
#define NN_DETAIL_PDM_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Info, 2, format, args)
#define NN_DETAIL_PDM_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Info, 3, format, args)

#define NN_DETAIL_PDM_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Warn, 0, format, args)
#define NN_DETAIL_PDM_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Warn, 1, format, args)
#define NN_DETAIL_PDM_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Warn, 2, format, args)
#define NN_DETAIL_PDM_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Warn, 3, format, args)

#define NN_DETAIL_PDM_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Error, 0, format, args)
#define NN_DETAIL_PDM_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Error, 1, format, args)
#define NN_DETAIL_PDM_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Error, 2, format, args)
#define NN_DETAIL_PDM_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Error, 3, format, args)

#define NN_DETAIL_PDM_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Fatal, 0, format, args)
#define NN_DETAIL_PDM_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Fatal, 1, format, args)
#define NN_DETAIL_PDM_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Fatal, 2, format, args)
#define NN_DETAIL_PDM_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pdm, Fatal, 3, format, args)

#define NN_DETAIL_PDM_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Trace, 0, text, length)
#define NN_DETAIL_PDM_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Trace, 1, text, length)
#define NN_DETAIL_PDM_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Trace, 2, text, length)
#define NN_DETAIL_PDM_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Trace, 3, text, length)

#define NN_DETAIL_PDM_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Info, 0, text, length)
#define NN_DETAIL_PDM_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Info, 1, text, length)
#define NN_DETAIL_PDM_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Info, 2, text, length)
#define NN_DETAIL_PDM_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Info, 3, text, length)

#define NN_DETAIL_PDM_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Warn, 0, text, length)
#define NN_DETAIL_PDM_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Warn, 1, text, length)
#define NN_DETAIL_PDM_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Warn, 2, text, length)
#define NN_DETAIL_PDM_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Warn, 3, text, length)

#define NN_DETAIL_PDM_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Error, 0, text, length)
#define NN_DETAIL_PDM_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Error, 1, text, length)
#define NN_DETAIL_PDM_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Error, 2, text, length)
#define NN_DETAIL_PDM_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Error, 3, text, length)

#define NN_DETAIL_PDM_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Fatal, 0, text, length)
#define NN_DETAIL_PDM_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Fatal, 1, text, length)
#define NN_DETAIL_PDM_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Fatal, 2, text, length)
#define NN_DETAIL_PDM_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pdm, Fatal, 3, text, length)
