﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace pcv {

 /**
 * @brief Enumerate the possible regulators/power domains to be accessed via the
 * PCV regulator APIs.
 *
 * @details Each power domain (voltage output) controlled by the PMIC regulators are listed here.
 */
enum PowerDomain
{
    PowerDomain_Max77620_Sd0,
    PowerDomain_Max77620_Sd1,
    PowerDomain_Max77620_Sd2,
    PowerDomain_Max77620_Sd3,

    PowerDomain_Max77620_Ldo0,
    PowerDomain_Max77620_Ldo1,
    PowerDomain_Max77620_Ldo2,
    PowerDomain_Max77620_Ldo3,
    PowerDomain_Max77620_Ldo4,
    PowerDomain_Max77620_Ldo5,
    PowerDomain_Max77620_Ldo6,
    PowerDomain_Max77620_Ldo7,
    PowerDomain_Max77620_Ldo8,

#if !defined NN_BUILD_CONFIG_HARDWARE_JETSONTK2
    PowerDomain_Max77621_Cpu,
    PowerDomain_Max77621_Gpu,

    PowerDomain_Max77812_Cpu,
    PowerDomain_Max77812_Gpu,
    PowerDomain_Max77812_Dram,
#endif

    PowerDomain_NumPowerDomain
};

} // namespace pcv
} // namespace nn
