﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief 操作可能な電源の定義。
 */

#pragma once

namespace nn { namespace pcv {

//! 操作可能な電源。
enum PowerControlTarget
{
    PowerControlTarget_SdCard, //!< SdCard の電源。
    PowerControlTarget_Hdmi, //!< HDMI の電源。
    PowerControlTarget_SioMcu, //!< MCU の電源（VDDIO）。
    PowerControlTarget_SioMcuA, //!< MCU の電源（VDDA）。

    PowerControlTarget_NumPowerControlTarget //!< 操作可能な電源の総数。
};

}} // namespace nn::pcv
