﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace pcv {

 /**
 * @brief Each component with power and clock control on the SOC.
 *
 * @details Each Module controlled by the SOC is listed here.
 */
enum Module {
    Module_Cpu,
    Module_Gpu,
    Module_I2s1,
    Module_I2s2,
    Module_I2s3,
    Module_Pwm,
    Module_I2c1,
    Module_I2c2,
    Module_I2c3,
    Module_I2c4,
    Module_I2c5,
    Module_I2c6,
    Module_Spi1,
    Module_Spi2,
    Module_Spi3,
    Module_Spi4,
    Module_Disp1,
    Module_Disp2,
    Module_Isp,
    Module_Vi,
    Module_Sdmmc1,
    Module_Sdmmc2,
    Module_Sdmmc3,
    Module_Sdmmc4,
    Module_Owr,
    Module_Csite,
    Module_Tsec,
    Module_Mselect,
    Module_Hda2codec2x,
    Module_Actmon,
    Module_I2cSlow,
    Module_Sor1,
    Module_Sata,
    Module_Hda,
    Module_XusbCoreHostSrc,
    Module_XusbFalconSrc,
    Module_XusbFsSrc,
    Module_XusbCoreDevSrc,
    Module_XusbSsSrc,
    Module_UartA,
    Module_UartB,
    Module_UartC,
    Module_UartD,
    Module_Hostx,
    Module_Entropy,
    Module_SocTherm,
    Module_Vic,
    Module_Nvenc,
    Module_Nvjpg,
    Module_Nvdec,
    Module_Qspi,
    Module_ViI2c,
    Module_Tsecb,
    Module_Ape,
    Module_AudioDsp,
    Module_AudioUart,
    Module_Emc,
    Module_Plle,
    Module_PlleHwSeq,
    Module_Dsi,
    Module_Maud,
    Module_Dpaux1,
    Module_MipiCal,
    Module_UartFstMipiCal,
    Module_Osc,
    Module_SysBus,
    Module_SorSafe,
    Module_XusbSs,
    Module_XusbHost,
    Module_XusbDevice,
    Module_Extperiph1,
    Module_Ahub,
    Module_Hda2hdmicodec,
    Module_Gpuaux,
    Module_UsbD,              // USB2 and USBD to control USB clks
    Module_Usb2,
    Module_Pcie,
    Module_Afi,
    Module_PciExClk,
    Module_PExUsbPhy,
    Module_XUsbPadCtl,
    Module_Apbdma,
    Module_Usb2TrkClk,
    Module_XUsbIoPll,         // In TRM, see enable PEX_PAD PLL sequence with xusb pad control
    Module_XUsbIoPllHwSeq,    // In TRM, see enable PEX_PAD PLL sequence with xusb pad control
    Module_Cec,

    Module_NumModule,   //!< Count of Module
};

} // namespace pcv
} // namespace nn
