﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief クロックを即座に操作する機能の初期化に関連する API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace pcv {

//-----------------------------------------------------------------------------
//! @name PCV ライブラリの即応機能の初期化、終了 API
//! @{

/**
 * @brief       PCV ライブラリの即応機能を初期化します。
 *
 * @post        PCV ライブラリの即応機能は初期化済の状態になります。
 *
 * @details     PCV ライブラリの即応機能を初期化します。
 *              本関数の呼び出し回数はライブラリ内部でカウントされます。
 */
void InitializeForImmediate() NN_NOEXCEPT;

/**
 * @brief       PCV ライブラリの即応機能を終了します。
 *
 * @post        PCV ライブラリの即応当該機能は初期化前の状態になります。
 *
 * @details     PCV ライブラリの即応機能を終了します。
 *              初期化を行った回数分、本関数が呼ばれた場合にのみ、
 *              初期化前の状態になります。
 */
void FinalizeForImmediate() NN_NOEXCEPT;

}} // namespace nn::pcv
