﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/pcv/pcv_Types.h>

namespace nn { namespace pcv { namespace driver { namespace detail {

struct DefaultState
{
    Module module;
    bool clockEnabled; // It might be replaced with ModuleState.
};

const DefaultState ExpectedDefaultStates[] =
{
    { nn::pcv::Module_I2s1,             true }, // Enabled By VCC
    { nn::pcv::Module_I2s2,             false },
    { nn::pcv::Module_I2s3,             false },
    { nn::pcv::Module_Pwm,              false },
    { nn::pcv::Module_I2c1,             true },
    { nn::pcv::Module_I2c2,             false },
    { nn::pcv::Module_I2c3,             false },
    { nn::pcv::Module_I2c4,             false },
    { nn::pcv::Module_I2c5,             true }, // Enabled By VCC
    { nn::pcv::Module_I2c6,             false },
    { nn::pcv::Module_Spi1,             false },
    { nn::pcv::Module_Spi2,             false },
    { nn::pcv::Module_Spi3,             false },
    { nn::pcv::Module_Spi4,             false },
    { nn::pcv::Module_Disp1,            false },
    { nn::pcv::Module_Disp2,            false },
    { nn::pcv::Module_Sdmmc1,           false },
    { nn::pcv::Module_Sdmmc2,           false },
    { nn::pcv::Module_Sdmmc3,           false },
    { nn::pcv::Module_Sdmmc4,           false },
    { nn::pcv::Module_Csite,            true },
    { nn::pcv::Module_Tsec,             false },
    { nn::pcv::Module_Mselect,          true }, // Always On
    { nn::pcv::Module_Hda2codec2x,      true }, // Enabled By VCC
    { nn::pcv::Module_Actmon,           true }, // Enabled By bootloader
    { nn::pcv::Module_I2cSlow,          false },
    { nn::pcv::Module_Sor1,             false },
    { nn::pcv::Module_Hda,              true }, // Enabled By VCC
    { nn::pcv::Module_XusbCoreHostSrc,  true }, // Always On
    { nn::pcv::Module_XusbFalconSrc,    true }, // Always On
    { nn::pcv::Module_XusbFsSrc,        true }, // Always On
    { nn::pcv::Module_XusbCoreDevSrc,   true }, // Always On
    { nn::pcv::Module_XusbSsSrc,        true }, // Always On
    { nn::pcv::Module_UartA,            true },
    { nn::pcv::Module_UartB,            false },
    { nn::pcv::Module_UartC,            false },
    { nn::pcv::Module_UartD,            false },
    { nn::pcv::Module_Hostx,            false },
    { nn::pcv::Module_Entropy,          true }, // Default On
    { nn::pcv::Module_SocTherm,         false },
    { nn::pcv::Module_Vic,              false },
    { nn::pcv::Module_Nvenc,            false },
    { nn::pcv::Module_Nvdec,            false },
    { nn::pcv::Module_Nvjpg,            false },
    { nn::pcv::Module_Qspi,             false },
    { nn::pcv::Module_Tsecb,            false },
    { nn::pcv::Module_Ape,              false },
    { nn::pcv::Module_AudioDsp,         false },
    { nn::pcv::Module_AudioUart,        false },
    { nn::pcv::Module_Emc,              true }, // Always On
    { nn::pcv::Module_Plle,             false },
    { nn::pcv::Module_PlleHwSeq,        false },
    { nn::pcv::Module_Dsi,              false },
    { nn::pcv::Module_Maud,             true }, // Enabled by VCC
    { nn::pcv::Module_Dpaux1,           false },
    { nn::pcv::Module_MipiCal,          false },
    { nn::pcv::Module_UartFstMipiCal,   true }, // Enabled by boot process
    { nn::pcv::Module_Osc,              true }, // Always On
    { nn::pcv::Module_SysBus,           true }, // Always On
    { nn::pcv::Module_SorSafe,          true }, // Enabled by VCC
    { nn::pcv::Module_XusbSs,           false }, // Gate control on multiple sources
    { nn::pcv::Module_XusbHost,         false }, // Gate control on multiple sources
    { nn::pcv::Module_XusbDevice,       false }, // Gate control on multiple sources
    { nn::pcv::Module_Extperiph1,       true }, // Enabled by VCC
    { nn::pcv::Module_Ahub,             true }, // Enabled by VCC
    { nn::pcv::Module_Hda2hdmicodec,    false },
    { nn::pcv::Module_Gpuaux,           true }, // Gate control on multiple sources
    { nn::pcv::Module_UsbD,             false },
    { nn::pcv::Module_Usb2,             false },
    { nn::pcv::Module_Pcie,             false },
    { nn::pcv::Module_Afi,              false },
    { nn::pcv::Module_Apbdma,           false },
    { nn::pcv::Module_Usb2TrkClk,       false },
    { nn::pcv::Module_XUsbIoPll,        false },
    { nn::pcv::Module_XUsbIoPllHwSeq,   false },
};

}}}} // namespace nn::pcv::driver::detail
