﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/pcv/pcv_Types.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace pcv { namespace detail { // NOLINT(whitespace/braces)

class IPcvService;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IPcvService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IPcvService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetPowerEnabled, (::std::int32_t moduleId, bool enabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetClockEnabled, (::std::int32_t moduleId, bool enabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetClockRate, (::std::int32_t moduleId, ::std::uint32_t clockRateHz))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetClockRate, (::nn::sf::Out<::std::uint32_t> pClockRateHz, ::std::int32_t moduleId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::nn::pcv::ModuleState> pState, ::std::int32_t moduleId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPossibleClockRates, (::nn::sf::Out<::std::int32_t> pOutType, const ::nn::sf::OutArray<::std::uint32_t>& pOutRates, ::nn::sf::Out<int> pOutCount, ::std::int32_t moduleId, int maxCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetMinVClockRate, (::std::int32_t moduleId, ::std::uint32_t clockRateHz))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetReset, (::std::int32_t moduleId, bool reset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetVoltageEnabled, (::std::int32_t powerDomain, bool enabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetVoltageEnabled, (::nn::sf::Out<bool> pEnabled, ::std::int32_t powerDomain))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetVoltageRange, (::nn::sf::Out<::std::int32_t> pMinVolt, ::nn::sf::Out<::std::int32_t> pMaxVolt, ::nn::sf::Out<::std::int32_t> pStepVolt, ::std::int32_t powerDomain))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetVoltageValue, (::std::int32_t powerDomain, ::std::int32_t microVolt))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetVoltageValue, (::nn::sf::Out<::std::int32_t> pMicroVolt, ::std::int32_t powerDomain))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTemperatureThresholds, (const ::nn::sf::OutArray<::nn::pcv::TemperatureThreshold>& pThresholds, ::nn::sf::Out<int> pOutCount, int maxCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetTemperature, (::std::int32_t temperatureMilliC))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Initialize)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsInitialized, (::nn::sf::Out<bool> pOutInitialized))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PowerOn, (::nn::pcv::PowerControlTarget powerControlTarget, ::nn::pcv::MicroVolt microVolt))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PowerOff, (::nn::pcv::PowerControlTarget powerControlTarget))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ChangeVoltage, (::nn::pcv::PowerControlTarget powerControlTarget, ::nn::pcv::MicroVolt microVolt))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPowerClockInfoEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetOscillatorClock, (::nn::sf::Out<::std::uint32_t> pClockRateHz))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDvfsTable, (const ::nn::sf::OutArray<::std::uint32_t>& pOutClocks, const ::nn::sf::OutArray<::std::int32_t>& pOutVoltages, ::nn::sf::Out<::std::int32_t> pOutCount, ::std::int32_t moduleId, ::std::int32_t maxCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetModuleStateTable, (const ::nn::sf::OutArray<::nn::pcv::ModuleState>& pOutModuleStates, ::nn::sf::Out<::std::int32_t> pOutCount, ::std::int32_t maxCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPowerDomainStateTable, (const ::nn::sf::OutArray<::nn::pcv::PowerDomainState>& pOutPowerDomainStates, ::nn::sf::Out<::std::int32_t> pOutCount, ::std::int32_t maxCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFuseInfo, (const ::nn::sf::OutArray<::std::uint32_t>& pOutValues, ::nn::sf::Out<::std::int32_t> pOutCount, ::std::int32_t maxCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDramId, (::nn::sf::Out<::std::uint32_t> pOutDramId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsPoweredOn, (::nn::sf::Out<bool> pOutIsPoweredOn, ::nn::pcv::PowerControlTarget powerControlTarget))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IPcvService)

        ::nn::Result SetPowerEnabled(::std::int32_t moduleId, bool enabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetPowerEnabled, (moduleId, enabled));
        }

        ::nn::Result SetClockEnabled(::std::int32_t moduleId, bool enabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetClockEnabled, (moduleId, enabled));
        }

        ::nn::Result SetClockRate(::std::int32_t moduleId, ::std::uint32_t clockRateHz) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetClockRate, (moduleId, clockRateHz));
        }

        ::nn::Result GetClockRate(::nn::sf::Out<::std::uint32_t> pClockRateHz, ::std::int32_t moduleId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetClockRate, (pClockRateHz, moduleId));
        }

        ::nn::Result GetState(::nn::sf::Out<::nn::pcv::ModuleState> pState, ::std::int32_t moduleId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetState, (pState, moduleId));
        }

        ::nn::Result GetPossibleClockRates(::nn::sf::Out<::std::int32_t> pOutType, const ::nn::sf::OutArray<::std::uint32_t>& pOutRates, ::nn::sf::Out<int> pOutCount, ::std::int32_t moduleId, int maxCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPossibleClockRates, (pOutType, pOutRates, pOutCount, moduleId, maxCount));
        }

        ::nn::Result SetMinVClockRate(::std::int32_t moduleId, ::std::uint32_t clockRateHz) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetMinVClockRate, (moduleId, clockRateHz));
        }

        ::nn::Result SetReset(::std::int32_t moduleId, bool reset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetReset, (moduleId, reset));
        }

        ::nn::Result SetVoltageEnabled(::std::int32_t powerDomain, bool enabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetVoltageEnabled, (powerDomain, enabled));
        }

        ::nn::Result GetVoltageEnabled(::nn::sf::Out<bool> pEnabled, ::std::int32_t powerDomain) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetVoltageEnabled, (pEnabled, powerDomain));
        }

        ::nn::Result GetVoltageRange(::nn::sf::Out<::std::int32_t> pMinVolt, ::nn::sf::Out<::std::int32_t> pMaxVolt, ::nn::sf::Out<::std::int32_t> pStepVolt, ::std::int32_t powerDomain) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetVoltageRange, (pMinVolt, pMaxVolt, pStepVolt, powerDomain));
        }

        ::nn::Result SetVoltageValue(::std::int32_t powerDomain, ::std::int32_t microVolt) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetVoltageValue, (powerDomain, microVolt));
        }

        ::nn::Result GetVoltageValue(::nn::sf::Out<::std::int32_t> pMicroVolt, ::std::int32_t powerDomain) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetVoltageValue, (pMicroVolt, powerDomain));
        }

        ::nn::Result GetTemperatureThresholds(const ::nn::sf::OutArray<::nn::pcv::TemperatureThreshold>& pThresholds, ::nn::sf::Out<int> pOutCount, int maxCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTemperatureThresholds, (pThresholds, pOutCount, maxCount));
        }

        ::nn::Result SetTemperature(::std::int32_t temperatureMilliC) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetTemperature, (temperatureMilliC));
        }

        ::nn::Result Initialize() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Initialize);
        }

        ::nn::Result IsInitialized(::nn::sf::Out<bool> pOutInitialized) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsInitialized, (pOutInitialized));
        }

        ::nn::Result Finalize() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Finalize);
        }

        ::nn::Result PowerOn(::nn::pcv::PowerControlTarget powerControlTarget, ::nn::pcv::MicroVolt microVolt) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PowerOn, (powerControlTarget, microVolt));
        }

        ::nn::Result PowerOff(::nn::pcv::PowerControlTarget powerControlTarget) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PowerOff, (powerControlTarget));
        }

        ::nn::Result ChangeVoltage(::nn::pcv::PowerControlTarget powerControlTarget, ::nn::pcv::MicroVolt microVolt) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ChangeVoltage, (powerControlTarget, microVolt));
        }

        ::nn::Result GetPowerClockInfoEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPowerClockInfoEvent, (outHandle));
        }

        ::nn::Result GetOscillatorClock(::nn::sf::Out<::std::uint32_t> pClockRateHz) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetOscillatorClock, (pClockRateHz));
        }

        ::nn::Result GetDvfsTable(const ::nn::sf::OutArray<::std::uint32_t>& pOutClocks, const ::nn::sf::OutArray<::std::int32_t>& pOutVoltages, ::nn::sf::Out<::std::int32_t> pOutCount, ::std::int32_t moduleId, ::std::int32_t maxCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDvfsTable, (pOutClocks, pOutVoltages, pOutCount, moduleId, maxCount));
        }

        ::nn::Result GetModuleStateTable(const ::nn::sf::OutArray<::nn::pcv::ModuleState>& pOutModuleStates, ::nn::sf::Out<::std::int32_t> pOutCount, ::std::int32_t maxCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetModuleStateTable, (pOutModuleStates, pOutCount, maxCount));
        }

        ::nn::Result GetPowerDomainStateTable(const ::nn::sf::OutArray<::nn::pcv::PowerDomainState>& pOutPowerDomainStates, ::nn::sf::Out<::std::int32_t> pOutCount, ::std::int32_t maxCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPowerDomainStateTable, (pOutPowerDomainStates, pOutCount, maxCount));
        }

        ::nn::Result GetFuseInfo(const ::nn::sf::OutArray<::std::uint32_t>& pOutValues, ::nn::sf::Out<::std::int32_t> pOutCount, ::std::int32_t maxCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFuseInfo, (pOutValues, pOutCount, maxCount));
        }

        ::nn::Result GetDramId(::nn::sf::Out<::std::uint32_t> pOutDramId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDramId, (pOutDramId));
        }

        ::nn::Result IsPoweredOn(::nn::sf::Out<bool> pOutIsPoweredOn, ::nn::pcv::PowerControlTarget powerControlTarget) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsPoweredOn, (pOutIsPoweredOn, powerControlTarget));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IPcvService
    {
    public:
        nn::Result SetPowerEnabled(std::int32_t moduleId, bool enabled) NN_NOEXCEPT;
        nn::Result SetClockEnabled(std::int32_t moduleId, bool enabled) NN_NOEXCEPT;
        nn::Result SetClockRate(std::int32_t moduleId, std::uint32_t clockRateHz) NN_NOEXCEPT;
        nn::Result GetClockRate(nn::sf::Out<std::uint32_t> pClockRateHz, std::int32_t moduleId) NN_NOEXCEPT;
        nn::Result GetState(nn::sf::Out<nn::pcv::ModuleState> pState, std::int32_t moduleId) NN_NOEXCEPT;
        nn::Result GetPossibleClockRates(nn::sf::Out<std::int32_t> pOutType, const nn::sf::OutArray<std::uint32_t>& pOutRates, nn::sf::Out<int> pOutCount, std::int32_t moduleId, int maxCount) NN_NOEXCEPT;
        nn::Result SetMinVClockRate(std::int32_t moduleId, std::uint32_t clockRateHz) NN_NOEXCEPT;
        nn::Result SetReset(std::int32_t moduleId, bool reset) NN_NOEXCEPT;
        nn::Result SetVoltageEnabled(std::int32_t powerDomain, bool enabled) NN_NOEXCEPT;
        nn::Result GetVoltageEnabled(nn::sf::Out<bool> pEnabled, std::int32_t powerDomain) NN_NOEXCEPT;
        nn::Result GetVoltageRange(nn::sf::Out<std::int32_t> pMinVolt, nn::sf::Out<std::int32_t> pMaxVolt, nn::sf::Out<std::int32_t> pStepVolt, std::int32_t powerDomain) NN_NOEXCEPT;
        nn::Result SetVoltageValue(std::int32_t powerDomain, std::int32_t microVolt) NN_NOEXCEPT;
        nn::Result GetVoltageValue(nn::sf::Out<std::int32_t> pMicroVolt, std::int32_t powerDomain) NN_NOEXCEPT;
        nn::Result GetTemperatureThresholds(const nn::sf::OutArray<nn::pcv::TemperatureThreshold>& pThresholds, nn::sf::Out<int> pOutCount, int maxCount) NN_NOEXCEPT;
        nn::Result SetTemperature(std::int32_t temperatureMilliC) NN_NOEXCEPT;
        nn::Result Initialize() NN_NOEXCEPT;
        nn::Result IsInitialized(nn::sf::Out<bool> pOutInitialized) NN_NOEXCEPT;
        nn::Result Finalize() NN_NOEXCEPT;
        nn::Result PowerOn(nn::pcv::PowerControlTarget powerControlTarget, nn::pcv::MicroVolt microVolt) NN_NOEXCEPT;
        nn::Result PowerOff(nn::pcv::PowerControlTarget powerControlTarget) NN_NOEXCEPT;
        nn::Result ChangeVoltage(nn::pcv::PowerControlTarget powerControlTarget, nn::pcv::MicroVolt microVolt) NN_NOEXCEPT;
        nn::Result GetPowerClockInfoEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
        nn::Result GetOscillatorClock(nn::sf::Out<std::uint32_t> pClockRateHz) NN_NOEXCEPT;
        nn::Result GetDvfsTable(const nn::sf::OutArray<std::uint32_t>& pOutClocks, const nn::sf::OutArray<std::int32_t>& pOutVoltages, nn::sf::Out<std::int32_t> pOutCount, std::int32_t moduleId, std::int32_t maxCount) NN_NOEXCEPT;
        nn::Result GetModuleStateTable(const nn::sf::OutArray<nn::pcv::ModuleState>& pOutModuleStates, nn::sf::Out<std::int32_t> pOutCount, std::int32_t maxCount) NN_NOEXCEPT;
        nn::Result GetPowerDomainStateTable(const nn::sf::OutArray<nn::pcv::PowerDomainState>& pOutPowerDomainStates, nn::sf::Out<std::int32_t> pOutCount, std::int32_t maxCount) NN_NOEXCEPT;
        nn::Result GetFuseInfo(const nn::sf::OutArray<std::uint32_t>& pOutValues, nn::sf::Out<std::int32_t> pOutCount, std::int32_t maxCount) NN_NOEXCEPT;
        nn::Result GetDramId(nn::sf::Out<std::uint32_t> pOutDramId) NN_NOEXCEPT;
        nn::Result IsPoweredOn(nn::sf::Out<bool> pOutIsPoweredOn, nn::pcv::PowerControlTarget powerControlTarget) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result SetPowerEnabled(std::int32_t moduleId, bool enabled) NN_NOEXCEPT;
    nn::Result SetClockEnabled(std::int32_t moduleId, bool enabled) NN_NOEXCEPT;
    nn::Result SetClockRate(std::int32_t moduleId, std::uint32_t clockRateHz) NN_NOEXCEPT;
    nn::Result GetClockRate(nn::sf::Out<std::uint32_t> pClockRateHz, std::int32_t moduleId) NN_NOEXCEPT;
    nn::Result GetState(nn::sf::Out<nn::pcv::ModuleState> pState, std::int32_t moduleId) NN_NOEXCEPT;
    nn::Result GetPossibleClockRates(nn::sf::Out<std::int32_t> pOutType, const nn::sf::OutArray<std::uint32_t>& pOutRates, nn::sf::Out<int> pOutCount, std::int32_t moduleId, int maxCount) NN_NOEXCEPT;
    nn::Result SetMinVClockRate(std::int32_t moduleId, std::uint32_t clockRateHz) NN_NOEXCEPT;
    nn::Result SetReset(std::int32_t moduleId, bool reset) NN_NOEXCEPT;
    nn::Result SetVoltageEnabled(std::int32_t powerDomain, bool enabled) NN_NOEXCEPT;
    nn::Result GetVoltageEnabled(nn::sf::Out<bool> pEnabled, std::int32_t powerDomain) NN_NOEXCEPT;
    nn::Result GetVoltageRange(nn::sf::Out<std::int32_t> pMinVolt, nn::sf::Out<std::int32_t> pMaxVolt, nn::sf::Out<std::int32_t> pStepVolt, std::int32_t powerDomain) NN_NOEXCEPT;
    nn::Result SetVoltageValue(std::int32_t powerDomain, std::int32_t microVolt) NN_NOEXCEPT;
    nn::Result GetVoltageValue(nn::sf::Out<std::int32_t> pMicroVolt, std::int32_t powerDomain) NN_NOEXCEPT;
    nn::Result GetTemperatureThresholds(const nn::sf::OutArray<nn::pcv::TemperatureThreshold>& pThresholds, nn::sf::Out<int> pOutCount, int maxCount) NN_NOEXCEPT;
    nn::Result SetTemperature(std::int32_t temperatureMilliC) NN_NOEXCEPT;
    nn::Result Initialize() NN_NOEXCEPT;
    nn::Result IsInitialized(nn::sf::Out<bool> pOutInitialized) NN_NOEXCEPT;
    nn::Result Finalize() NN_NOEXCEPT;
    nn::Result PowerOn(nn::pcv::PowerControlTarget powerControlTarget, nn::pcv::MicroVolt microVolt) NN_NOEXCEPT;
    nn::Result PowerOff(nn::pcv::PowerControlTarget powerControlTarget) NN_NOEXCEPT;
    nn::Result ChangeVoltage(nn::pcv::PowerControlTarget powerControlTarget, nn::pcv::MicroVolt microVolt) NN_NOEXCEPT;
    nn::Result GetPowerClockInfoEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result GetOscillatorClock(nn::sf::Out<std::uint32_t> pClockRateHz) NN_NOEXCEPT;
    nn::Result GetDvfsTable(const nn::sf::OutArray<std::uint32_t>& pOutClocks, const nn::sf::OutArray<std::int32_t>& pOutVoltages, nn::sf::Out<std::int32_t> pOutCount, std::int32_t moduleId, std::int32_t maxCount) NN_NOEXCEPT;
    nn::Result GetModuleStateTable(const nn::sf::OutArray<nn::pcv::ModuleState>& pOutModuleStates, nn::sf::Out<std::int32_t> pOutCount, std::int32_t maxCount) NN_NOEXCEPT;
    nn::Result GetPowerDomainStateTable(const nn::sf::OutArray<nn::pcv::PowerDomainState>& pOutPowerDomainStates, nn::sf::Out<std::int32_t> pOutCount, std::int32_t maxCount) NN_NOEXCEPT;
    nn::Result GetFuseInfo(const nn::sf::OutArray<std::uint32_t>& pOutValues, nn::sf::Out<std::int32_t> pOutCount, std::int32_t maxCount) NN_NOEXCEPT;
    nn::Result GetDramId(nn::sf::Out<std::uint32_t> pOutDramId) NN_NOEXCEPT;
    nn::Result IsPoweredOn(nn::sf::Out<bool> pOutIsPoweredOn, nn::pcv::PowerControlTarget powerControlTarget) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::pcv::detail::IPcvService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPowerEnabled, (::std::int32_t moduleId, bool enabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetPowerEnabled, (moduleId, enabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetClockEnabled, (::std::int32_t moduleId, bool enabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetClockEnabled, (moduleId, enabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetClockRate, (::std::int32_t moduleId, ::std::uint32_t clockRateHz))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetClockRate, (moduleId, clockRateHz));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetClockRate, (::nn::sf::Out<::std::uint32_t> pClockRateHz, ::std::int32_t moduleId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetClockRate, (pClockRateHz, moduleId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::nn::pcv::ModuleState> pState, ::std::int32_t moduleId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetState, (pState, moduleId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPossibleClockRates, (::nn::sf::Out<::std::int32_t> pOutType, const ::nn::sf::OutArray<::std::uint32_t>& pOutRates, ::nn::sf::Out<int> pOutCount, ::std::int32_t moduleId, int maxCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPossibleClockRates, (pOutType, pOutRates, pOutCount, moduleId, maxCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMinVClockRate, (::std::int32_t moduleId, ::std::uint32_t clockRateHz))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetMinVClockRate, (moduleId, clockRateHz));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetReset, (::std::int32_t moduleId, bool reset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetReset, (moduleId, reset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetVoltageEnabled, (::std::int32_t powerDomain, bool enabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetVoltageEnabled, (powerDomain, enabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetVoltageEnabled, (::nn::sf::Out<bool> pEnabled, ::std::int32_t powerDomain))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetVoltageEnabled, (pEnabled, powerDomain));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetVoltageRange, (::nn::sf::Out<::std::int32_t> pMinVolt, ::nn::sf::Out<::std::int32_t> pMaxVolt, ::nn::sf::Out<::std::int32_t> pStepVolt, ::std::int32_t powerDomain))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetVoltageRange, (pMinVolt, pMaxVolt, pStepVolt, powerDomain));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetVoltageValue, (::std::int32_t powerDomain, ::std::int32_t microVolt))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetVoltageValue, (powerDomain, microVolt));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetVoltageValue, (::nn::sf::Out<::std::int32_t> pMicroVolt, ::std::int32_t powerDomain))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetVoltageValue, (pMicroVolt, powerDomain));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTemperatureThresholds, (const ::nn::sf::OutArray<::nn::pcv::TemperatureThreshold>& pThresholds, ::nn::sf::Out<int> pOutCount, int maxCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTemperatureThresholds, (pThresholds, pOutCount, maxCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetTemperature, (::std::int32_t temperatureMilliC))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetTemperature, (temperatureMilliC));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Initialize)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Initialize);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsInitialized, (::nn::sf::Out<bool> pOutInitialized))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsInitialized, (pOutInitialized));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Finalize);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PowerOn, (::nn::pcv::PowerControlTarget powerControlTarget, ::nn::pcv::MicroVolt microVolt))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PowerOn, (powerControlTarget, microVolt));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PowerOff, (::nn::pcv::PowerControlTarget powerControlTarget))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PowerOff, (powerControlTarget));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ChangeVoltage, (::nn::pcv::PowerControlTarget powerControlTarget, ::nn::pcv::MicroVolt microVolt))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ChangeVoltage, (powerControlTarget, microVolt));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPowerClockInfoEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPowerClockInfoEvent, (outHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetOscillatorClock, (::nn::sf::Out<::std::uint32_t> pClockRateHz))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetOscillatorClock, (pClockRateHz));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDvfsTable, (const ::nn::sf::OutArray<::std::uint32_t>& pOutClocks, const ::nn::sf::OutArray<::std::int32_t>& pOutVoltages, ::nn::sf::Out<::std::int32_t> pOutCount, ::std::int32_t moduleId, ::std::int32_t maxCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDvfsTable, (pOutClocks, pOutVoltages, pOutCount, moduleId, maxCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetModuleStateTable, (const ::nn::sf::OutArray<::nn::pcv::ModuleState>& pOutModuleStates, ::nn::sf::Out<::std::int32_t> pOutCount, ::std::int32_t maxCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetModuleStateTable, (pOutModuleStates, pOutCount, maxCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPowerDomainStateTable, (const ::nn::sf::OutArray<::nn::pcv::PowerDomainState>& pOutPowerDomainStates, ::nn::sf::Out<::std::int32_t> pOutCount, ::std::int32_t maxCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPowerDomainStateTable, (pOutPowerDomainStates, pOutCount, maxCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFuseInfo, (const ::nn::sf::OutArray<::std::uint32_t>& pOutValues, ::nn::sf::Out<::std::int32_t> pOutCount, ::std::int32_t maxCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFuseInfo, (pOutValues, pOutCount, maxCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDramId, (::nn::sf::Out<::std::uint32_t> pOutDramId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDramId, (pOutDramId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsPoweredOn, (::nn::sf::Out<bool> pOutIsPoweredOn, ::nn::pcv::PowerControlTarget powerControlTarget))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsPoweredOn, (pOutIsPoweredOn, powerControlTarget));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::pcv::detail::IPcvService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::pcv::detail::IPcvService))

    // nn::Result SetPowerEnabled(std::int32_t moduleId, bool enabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetPowerEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(enabled, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(moduleId, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (enabled, moduleId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(moduleId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(enabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetPowerEnabled)

    // nn::Result SetClockEnabled(std::int32_t moduleId, bool enabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetClockEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(enabled, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(moduleId, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (enabled, moduleId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(moduleId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(enabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetClockEnabled)

    // nn::Result SetClockRate(std::int32_t moduleId, std::uint32_t clockRateHz) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetClockRate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(moduleId, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(clockRateHz, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (moduleId, clockRateHz))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(moduleId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(clockRateHz)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetClockRate)

    // nn::Result GetClockRate(nn::sf::Out<std::uint32_t> pClockRateHz, std::int32_t moduleId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetClockRate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(moduleId, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (moduleId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pClockRateHz, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pClockRateHz))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pClockRateHz), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(moduleId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetClockRate)

    // nn::Result GetState(nn::sf::Out<nn::pcv::ModuleState> pState, std::int32_t moduleId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(moduleId, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (moduleId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pState, (::nn::pcv::ModuleState), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pState), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(moduleId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetState)

    // nn::Result GetPossibleClockRates(nn::sf::Out<std::int32_t> pOutType, const nn::sf::OutArray<std::uint32_t>& pOutRates, nn::sf::Out<int> pOutCount, std::int32_t moduleId, int maxCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPossibleClockRates)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutRates, 0, (const ::nn::sf::OutArray<::std::uint32_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutRates))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(moduleId, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maxCount, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (moduleId, maxCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutType, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutType, pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRates), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(moduleId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maxCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPossibleClockRates)

    // nn::Result SetMinVClockRate(std::int32_t moduleId, std::uint32_t clockRateHz) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetMinVClockRate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(moduleId, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(clockRateHz, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (moduleId, clockRateHz))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(moduleId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(clockRateHz)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetMinVClockRate)

    // nn::Result SetReset(std::int32_t moduleId, bool reset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetReset)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(reset, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(moduleId, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (reset, moduleId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(moduleId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(reset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetReset)

    // nn::Result SetVoltageEnabled(std::int32_t powerDomain, bool enabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetVoltageEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(enabled, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(powerDomain, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (enabled, powerDomain))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(powerDomain), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(enabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetVoltageEnabled)

    // nn::Result GetVoltageEnabled(nn::sf::Out<bool> pEnabled, std::int32_t powerDomain) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetVoltageEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(powerDomain, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (powerDomain))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEnabled), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(powerDomain)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetVoltageEnabled)

    // nn::Result GetVoltageRange(nn::sf::Out<std::int32_t> pMinVolt, nn::sf::Out<std::int32_t> pMaxVolt, nn::sf::Out<std::int32_t> pStepVolt, std::int32_t powerDomain) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetVoltageRange)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(powerDomain, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (powerDomain))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pMinVolt, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pMaxVolt, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pStepVolt, (::std::int32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pMinVolt, pMaxVolt, pStepVolt))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pMinVolt), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pMaxVolt), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pStepVolt), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(powerDomain)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetVoltageRange)

    // nn::Result SetVoltageValue(std::int32_t powerDomain, std::int32_t microVolt) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetVoltageValue)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(powerDomain, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(microVolt, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (powerDomain, microVolt))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(powerDomain), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(microVolt)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetVoltageValue)

    // nn::Result GetVoltageValue(nn::sf::Out<std::int32_t> pMicroVolt, std::int32_t powerDomain) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetVoltageValue)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(powerDomain, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (powerDomain))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pMicroVolt, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pMicroVolt))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pMicroVolt), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(powerDomain)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetVoltageValue)

    // nn::Result GetTemperatureThresholds(const nn::sf::OutArray<nn::pcv::TemperatureThreshold>& pThresholds, nn::sf::Out<int> pOutCount, int maxCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTemperatureThresholds)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pThresholds, 0, (const ::nn::sf::OutArray<::nn::pcv::TemperatureThreshold>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pThresholds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maxCount, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (maxCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pThresholds), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maxCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTemperatureThresholds)

    // nn::Result SetTemperature(std::int32_t temperatureMilliC) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetTemperature)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(temperatureMilliC, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (temperatureMilliC))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(temperatureMilliC)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetTemperature)

    // nn::Result Initialize() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Initialize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Initialize)

    // nn::Result IsInitialized(nn::sf::Out<bool> pOutInitialized) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsInitialized)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutInitialized, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutInitialized))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutInitialized)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsInitialized)

    // nn::Result Finalize() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Finalize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Finalize)

    // nn::Result PowerOn(nn::pcv::PowerControlTarget powerControlTarget, nn::pcv::MicroVolt microVolt) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PowerOn)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(powerControlTarget, (::nn::pcv::PowerControlTarget), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(microVolt, (::nn::pcv::MicroVolt), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (powerControlTarget, microVolt))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(powerControlTarget), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(microVolt)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PowerOn)

    // nn::Result PowerOff(nn::pcv::PowerControlTarget powerControlTarget) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PowerOff)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(powerControlTarget, (::nn::pcv::PowerControlTarget), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (powerControlTarget))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(powerControlTarget)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PowerOff)

    // nn::Result ChangeVoltage(nn::pcv::PowerControlTarget powerControlTarget, nn::pcv::MicroVolt microVolt) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ChangeVoltage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(powerControlTarget, (::nn::pcv::PowerControlTarget), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(microVolt, (::nn::pcv::MicroVolt), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (powerControlTarget, microVolt))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(powerControlTarget), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(microVolt)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ChangeVoltage)

    // nn::Result GetPowerClockInfoEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPowerClockInfoEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPowerClockInfoEvent)

    // nn::Result GetOscillatorClock(nn::sf::Out<std::uint32_t> pClockRateHz) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetOscillatorClock)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pClockRateHz, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pClockRateHz))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pClockRateHz)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetOscillatorClock)

    // nn::Result GetDvfsTable(const nn::sf::OutArray<std::uint32_t>& pOutClocks, const nn::sf::OutArray<std::int32_t>& pOutVoltages, nn::sf::Out<std::int32_t> pOutCount, std::int32_t moduleId, std::int32_t maxCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDvfsTable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutClocks, 0, (const ::nn::sf::OutArray<::std::uint32_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutVoltages, 1, (const ::nn::sf::OutArray<::std::int32_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pOutClocks, pOutVoltages))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(moduleId, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maxCount, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (moduleId, maxCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutClocks), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutVoltages), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(moduleId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maxCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDvfsTable)

    // nn::Result GetModuleStateTable(const nn::sf::OutArray<nn::pcv::ModuleState>& pOutModuleStates, nn::sf::Out<std::int32_t> pOutCount, std::int32_t maxCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetModuleStateTable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutModuleStates, 0, (const ::nn::sf::OutArray<::nn::pcv::ModuleState>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutModuleStates))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maxCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (maxCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutModuleStates), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maxCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetModuleStateTable)

    // nn::Result GetPowerDomainStateTable(const nn::sf::OutArray<nn::pcv::PowerDomainState>& pOutPowerDomainStates, nn::sf::Out<std::int32_t> pOutCount, std::int32_t maxCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPowerDomainStateTable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutPowerDomainStates, 0, (const ::nn::sf::OutArray<::nn::pcv::PowerDomainState>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutPowerDomainStates))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maxCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (maxCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutPowerDomainStates), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maxCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPowerDomainStateTable)

    // nn::Result GetFuseInfo(const nn::sf::OutArray<std::uint32_t>& pOutValues, nn::sf::Out<std::int32_t> pOutCount, std::int32_t maxCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFuseInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutValues, 0, (const ::nn::sf::OutArray<::std::uint32_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutValues))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maxCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (maxCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutValues), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maxCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFuseInfo)

    // nn::Result GetDramId(nn::sf::Out<std::uint32_t> pOutDramId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDramId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(27)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutDramId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutDramId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutDramId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDramId)

    // nn::Result IsPoweredOn(nn::sf::Out<bool> pOutIsPoweredOn, nn::pcv::PowerControlTarget powerControlTarget) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsPoweredOn)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(28)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(powerControlTarget, (::nn::pcv::PowerControlTarget), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (powerControlTarget))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutIsPoweredOn, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutIsPoweredOn))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutIsPoweredOn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(powerControlTarget)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsPoweredOn)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pcv::ModuleState), 12, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pcv::TemperatureThreshold), 8, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pcv::PowerControlTarget), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pcv::MicroVolt), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pcv::PowerDomainState), 8, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::pcv::detail::IPcvService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::pcv::detail::IPcvService))

    // nn::Result SetPowerEnabled(std::int32_t moduleId, bool enabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPowerEnabled, (::std::int32_t moduleId, bool enabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetPowerEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(moduleId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(enabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetPowerEnabled)
    }

    // nn::Result SetClockEnabled(std::int32_t moduleId, bool enabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetClockEnabled, (::std::int32_t moduleId, bool enabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetClockEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(moduleId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(enabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetClockEnabled)
    }

    // nn::Result SetClockRate(std::int32_t moduleId, std::uint32_t clockRateHz) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetClockRate, (::std::int32_t moduleId, ::std::uint32_t clockRateHz))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetClockRate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(moduleId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(clockRateHz)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetClockRate)
    }

    // nn::Result GetClockRate(nn::sf::Out<std::uint32_t> pClockRateHz, std::int32_t moduleId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetClockRate, (::nn::sf::Out<::std::uint32_t> pClockRateHz, ::std::int32_t moduleId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetClockRate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pClockRateHz)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(moduleId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetClockRate)
    }

    // nn::Result GetState(nn::sf::Out<nn::pcv::ModuleState> pState, std::int32_t moduleId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::nn::pcv::ModuleState> pState, ::std::int32_t moduleId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(moduleId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetState)
    }

    // nn::Result GetPossibleClockRates(nn::sf::Out<std::int32_t> pOutType, const nn::sf::OutArray<std::uint32_t>& pOutRates, nn::sf::Out<int> pOutCount, std::int32_t moduleId, int maxCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPossibleClockRates, (::nn::sf::Out<::std::int32_t> pOutType, const ::nn::sf::OutArray<::std::uint32_t>& pOutRates, ::nn::sf::Out<int> pOutCount, ::std::int32_t moduleId, int maxCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPossibleClockRates)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRates)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(moduleId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maxCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPossibleClockRates)
    }

    // nn::Result SetMinVClockRate(std::int32_t moduleId, std::uint32_t clockRateHz) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMinVClockRate, (::std::int32_t moduleId, ::std::uint32_t clockRateHz))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetMinVClockRate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(moduleId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(clockRateHz)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetMinVClockRate)
    }

    // nn::Result SetReset(std::int32_t moduleId, bool reset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetReset, (::std::int32_t moduleId, bool reset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetReset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(moduleId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(reset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetReset)
    }

    // nn::Result SetVoltageEnabled(std::int32_t powerDomain, bool enabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetVoltageEnabled, (::std::int32_t powerDomain, bool enabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetVoltageEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(powerDomain)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(enabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetVoltageEnabled)
    }

    // nn::Result GetVoltageEnabled(nn::sf::Out<bool> pEnabled, std::int32_t powerDomain) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetVoltageEnabled, (::nn::sf::Out<bool> pEnabled, ::std::int32_t powerDomain))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetVoltageEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(powerDomain)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetVoltageEnabled)
    }

    // nn::Result GetVoltageRange(nn::sf::Out<std::int32_t> pMinVolt, nn::sf::Out<std::int32_t> pMaxVolt, nn::sf::Out<std::int32_t> pStepVolt, std::int32_t powerDomain) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetVoltageRange, (::nn::sf::Out<::std::int32_t> pMinVolt, ::nn::sf::Out<::std::int32_t> pMaxVolt, ::nn::sf::Out<::std::int32_t> pStepVolt, ::std::int32_t powerDomain))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetVoltageRange)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pMinVolt)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pMaxVolt)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pStepVolt)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(powerDomain)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetVoltageRange)
    }

    // nn::Result SetVoltageValue(std::int32_t powerDomain, std::int32_t microVolt) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetVoltageValue, (::std::int32_t powerDomain, ::std::int32_t microVolt))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetVoltageValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(powerDomain)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(microVolt)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetVoltageValue)
    }

    // nn::Result GetVoltageValue(nn::sf::Out<std::int32_t> pMicroVolt, std::int32_t powerDomain) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetVoltageValue, (::nn::sf::Out<::std::int32_t> pMicroVolt, ::std::int32_t powerDomain))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetVoltageValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pMicroVolt)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(powerDomain)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetVoltageValue)
    }

    // nn::Result GetTemperatureThresholds(const nn::sf::OutArray<nn::pcv::TemperatureThreshold>& pThresholds, nn::sf::Out<int> pOutCount, int maxCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTemperatureThresholds, (const ::nn::sf::OutArray<::nn::pcv::TemperatureThreshold>& pThresholds, ::nn::sf::Out<int> pOutCount, int maxCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTemperatureThresholds)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pThresholds)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maxCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTemperatureThresholds)
    }

    // nn::Result SetTemperature(std::int32_t temperatureMilliC) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetTemperature, (::std::int32_t temperatureMilliC))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetTemperature)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(temperatureMilliC)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetTemperature)
    }

    // nn::Result Initialize() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Initialize)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Initialize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Initialize)
    }

    // nn::Result IsInitialized(nn::sf::Out<bool> pOutInitialized) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsInitialized, (::nn::sf::Out<bool> pOutInitialized))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsInitialized)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutInitialized)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsInitialized)
    }

    // nn::Result Finalize() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Finalize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Finalize)
    }

    // nn::Result PowerOn(nn::pcv::PowerControlTarget powerControlTarget, nn::pcv::MicroVolt microVolt) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PowerOn, (::nn::pcv::PowerControlTarget powerControlTarget, ::nn::pcv::MicroVolt microVolt))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PowerOn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(powerControlTarget)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(microVolt)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PowerOn)
    }

    // nn::Result PowerOff(nn::pcv::PowerControlTarget powerControlTarget) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PowerOff, (::nn::pcv::PowerControlTarget powerControlTarget))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PowerOff)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(powerControlTarget)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PowerOff)
    }

    // nn::Result ChangeVoltage(nn::pcv::PowerControlTarget powerControlTarget, nn::pcv::MicroVolt microVolt) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ChangeVoltage, (::nn::pcv::PowerControlTarget powerControlTarget, ::nn::pcv::MicroVolt microVolt))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ChangeVoltage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(powerControlTarget)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(microVolt)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ChangeVoltage)
    }

    // nn::Result GetPowerClockInfoEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPowerClockInfoEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPowerClockInfoEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPowerClockInfoEvent)
    }

    // nn::Result GetOscillatorClock(nn::sf::Out<std::uint32_t> pClockRateHz) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetOscillatorClock, (::nn::sf::Out<::std::uint32_t> pClockRateHz))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetOscillatorClock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pClockRateHz)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetOscillatorClock)
    }

    // nn::Result GetDvfsTable(const nn::sf::OutArray<std::uint32_t>& pOutClocks, const nn::sf::OutArray<std::int32_t>& pOutVoltages, nn::sf::Out<std::int32_t> pOutCount, std::int32_t moduleId, std::int32_t maxCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDvfsTable, (const ::nn::sf::OutArray<::std::uint32_t>& pOutClocks, const ::nn::sf::OutArray<::std::int32_t>& pOutVoltages, ::nn::sf::Out<::std::int32_t> pOutCount, ::std::int32_t moduleId, ::std::int32_t maxCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDvfsTable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutClocks)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutVoltages)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(moduleId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maxCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDvfsTable)
    }

    // nn::Result GetModuleStateTable(const nn::sf::OutArray<nn::pcv::ModuleState>& pOutModuleStates, nn::sf::Out<std::int32_t> pOutCount, std::int32_t maxCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetModuleStateTable, (const ::nn::sf::OutArray<::nn::pcv::ModuleState>& pOutModuleStates, ::nn::sf::Out<::std::int32_t> pOutCount, ::std::int32_t maxCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetModuleStateTable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutModuleStates)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maxCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetModuleStateTable)
    }

    // nn::Result GetPowerDomainStateTable(const nn::sf::OutArray<nn::pcv::PowerDomainState>& pOutPowerDomainStates, nn::sf::Out<std::int32_t> pOutCount, std::int32_t maxCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPowerDomainStateTable, (const ::nn::sf::OutArray<::nn::pcv::PowerDomainState>& pOutPowerDomainStates, ::nn::sf::Out<::std::int32_t> pOutCount, ::std::int32_t maxCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPowerDomainStateTable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutPowerDomainStates)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maxCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPowerDomainStateTable)
    }

    // nn::Result GetFuseInfo(const nn::sf::OutArray<std::uint32_t>& pOutValues, nn::sf::Out<std::int32_t> pOutCount, std::int32_t maxCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFuseInfo, (const ::nn::sf::OutArray<::std::uint32_t>& pOutValues, ::nn::sf::Out<::std::int32_t> pOutCount, ::std::int32_t maxCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFuseInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutValues)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maxCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFuseInfo)
    }

    // nn::Result GetDramId(nn::sf::Out<std::uint32_t> pOutDramId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDramId, (::nn::sf::Out<::std::uint32_t> pOutDramId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDramId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutDramId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDramId)
    }

    // nn::Result IsPoweredOn(nn::sf::Out<bool> pOutIsPoweredOn, nn::pcv::PowerControlTarget powerControlTarget) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsPoweredOn, (::nn::sf::Out<bool> pOutIsPoweredOn, ::nn::pcv::PowerControlTarget powerControlTarget))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsPoweredOn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutIsPoweredOn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(powerControlTarget)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsPoweredOn)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::pcv::detail::IPcvService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::pcv::detail::IPcvService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetPowerEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetPowerEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(moduleId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(enabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetClockEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetClockEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(moduleId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(enabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetClockRate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetClockRate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(moduleId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(clockRateHz)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetClockRate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetClockRate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pClockRateHz),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(moduleId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pState),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(moduleId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPossibleClockRates)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutRates)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPossibleClockRates)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutRates),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(moduleId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maxCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetMinVClockRate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetMinVClockRate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(moduleId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(clockRateHz)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetReset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetReset)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(moduleId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(reset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetVoltageEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetVoltageEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(powerDomain),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(enabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetVoltageEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetVoltageEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pEnabled),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(powerDomain)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetVoltageRange)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetVoltageRange)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pMinVolt),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pMaxVolt),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pStepVolt),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(powerDomain)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetVoltageValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetVoltageValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(powerDomain),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(microVolt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetVoltageValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetVoltageValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pMicroVolt),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(powerDomain)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTemperatureThresholds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pThresholds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTemperatureThresholds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pThresholds),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maxCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetTemperature)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetTemperature)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(temperatureMilliC)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsInitialized)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsInitialized)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutInitialized)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PowerOn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PowerOn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(powerControlTarget),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(microVolt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PowerOff)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PowerOff)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(powerControlTarget)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ChangeVoltage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ChangeVoltage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(powerControlTarget),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(microVolt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPowerClockInfoEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPowerClockInfoEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetOscillatorClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetOscillatorClock)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pClockRateHz)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDvfsTable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutClocks)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutVoltages)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDvfsTable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutClocks),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutVoltages),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(moduleId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maxCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetModuleStateTable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutModuleStates)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetModuleStateTable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutModuleStates),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maxCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPowerDomainStateTable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutPowerDomainStates)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPowerDomainStateTable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutPowerDomainStates),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maxCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFuseInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutValues)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFuseInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutValues),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maxCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDramId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDramId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutDramId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsPoweredOn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsPoweredOn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutIsPoweredOn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(powerControlTarget)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetPowerEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetClockEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetClockRate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetClockRate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPossibleClockRates)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetMinVClockRate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetReset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetVoltageEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetVoltageEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetVoltageRange)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetVoltageValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetVoltageValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTemperatureThresholds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetTemperature)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsInitialized)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PowerOn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PowerOff)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ChangeVoltage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPowerClockInfoEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetOscillatorClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDvfsTable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetModuleStateTable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPowerDomainStateTable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFuseInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDramId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsPoweredOn)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::pcv::detail::IPcvService))
