﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace pctl {

/**
 * @brief お問い合わせ番号の文字列表現データ(終端のNULL文字含む)の最大サイズです。
 * @details 実際の文字列はこの値より小さい長さになります。
 */
static const size_t MaxInquiryCodeStringSize = 16;

/**
 * @brief マスターキー発行用のお問い合わせ番号を表す構造体です。
 */
struct InquiryCode
{
    /**
     * @brief お問い合わせ番号の文字列表現のデータです。
     * @details
     * このデータには終端のNULL文字も含まれるため、そのまま文字列として扱うことができます。@n
     * なお、文字列の長さは @ref MaxInquiryCodeStringSize 未満となります。
     */
    char codeString[MaxInquiryCodeStringSize];
    /**
     * @private
     * @brief 予約領域のため使用しないでください。
     */
    char _reserved[16];
};

}}
