﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/pctl/pctl_ResultSnsPost.h>

namespace nn { namespace pctl {

/**
 * @name SNS投稿のペアコン状態チェック関数
 * @{
 */

/**
 * @brief ペアコンの設定に基づいてSNS投稿が利用可能かどうかを確認します。
 * @return nn::Result の値
 * @retval nn::ResultSuccess SNS投稿が可能です(制限されていないか一時解除状態です)
 * @retval nn::pctl::ResultSnsPostRestricted SNS投稿が制限されています
 *
 * @details
 * 本関数は一時解除状態であるかどうかも加味した値を返します。
 * 一時解除状態である場合は nn::ResultSuccess が返ります。
 */
nn::Result ConfirmSnsPostPermission() NN_NOEXCEPT;

/**
 * @}
 */

}}
