﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>

namespace nn { namespace pctl {

/**
 * @name テスト用ペアレンタルコントロール処理関数
 * @{
 */

/**
 * @brief プレイタイマーによって消費(経過)した時間を取得します。
 * @return 消費時間
 *
 * @details
 * 消費時間はプレイタイマーが稼働しているときにのみカウントされます。
 * また、日付が変わったタイミングで 0 にリセットされます。
 *
 * 本体がメンテナンスモードで起動されている場合、本関数は 0 を返します。
 */
nn::TimeSpan GetPlayTimerSpentTimeForTest() NN_NOEXCEPT;

/**
 * @}
 */

}}
