﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/pctl/pctl_ResultPrivate.h>
#include <nn/pctl/pctl_TypesWatcher.h>
#include <nn/pctl/detail/service/json/pctl_JsonWebApi.h>
#include <nn/util/util_StringUtil.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

// @brief Watcher機能での通信処理共通のエラーハンドラークラスです。
// @details 一定のサイズ(1KiB以上)を有するためスタック上に確保するとスタック不足になる可能性があります。
class WatcherErrorHandler : public json::JsonWebErrorDataHandler
{
public:
    WatcherErrorHandler() NN_NOEXCEPT;
    explicit WatcherErrorHandler(json::HandleWebErrorFunction errorCallback, void* paramCallback) NN_NOEXCEPT;

    void SetProblemDetailsAvailable() NN_NOEXCEPT
    {
        m_IsProblemDetailsAvailable = true;
    }
    void SetType(const char* value, size_t length) NN_NOEXCEPT;
    void SetStatus(int status) NN_NOEXCEPT
    {
        m_ProblemDetails.status = status;
    }
    void SetTitle(const char* value, size_t length) NN_NOEXCEPT
    {
        if (length > std::extent<decltype(m_ProblemDetails.title)>::value - 1)
        {
            length = std::extent<decltype(m_ProblemDetails.title)>::value - 1;
        }
        std::memcpy(m_ProblemDetails.title, value, sizeof(char) * (length));
        m_ProblemDetails.title[length] = 0;
    }
    void SetErrorCode(const char* value, size_t length) NN_NOEXCEPT
    {
        if (length > std::extent<decltype(m_ProblemDetails.errorCode)>::value - 1)
        {
            length = std::extent<decltype(m_ProblemDetails.errorCode)>::value - 1;
        }
        std::memcpy(m_ProblemDetails.errorCode, value, sizeof(char) * (length));
        m_ProblemDetails.errorCode[length] = 0;
    }
    void SetDetail(const char* value, size_t length) NN_NOEXCEPT
    {
        if (length > std::extent<decltype(m_ProblemDetails.detail)>::value - 1)
        {
            length = std::extent<decltype(m_ProblemDetails.detail)>::value - 1;
        }
        std::memcpy(m_ProblemDetails.detail, value, sizeof(char) * (length));
        m_ProblemDetails.detail[length] = 0;
    }

private:
    static nn::Result HandleError(void* param, int statusCode, nn::Result defaultResult) NN_NOEXCEPT;

    struct ProblemDetails
    {
        nn::Result resultByType;
        int status;
        char title[64];
        char errorCode[32];  // (JSONデータ上の「errorCode」でありNXエラーコードではない)
        char detail[128];
    };

    json::HandleWebErrorFunction m_ErrorCallback;
    void* m_ParamCallback;
    bool m_IsProblemDetailsAvailable;
    ProblemDetails m_ProblemDetails;
};

}}}}}
