﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/pctl/detail/service/common/pctl_AsyncContext.h>
#include <nn/pctl/detail/service/common/pctl_Cancelable.h>
#include <nn/pctl/detail/service/watcher/pctl_ServerResource.h>
#include <nn/pctl/detail/service/watcher/pctl_WatcherData.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

////////////////////////////////////////////////////////////////////////////////

//! @brief 指定のデバイスとアカウントに対する連携を解除します。
class UnlinkDevice
{
public:
    static nn::Result Execute(common::NetworkBuffer& bufferInfo, common::Cancelable* pCancelable, const char* token,
        ServerDeviceId deviceId, NintendoAccountId accountId) NN_NOEXCEPT;
};

////////////////////////////////////////////////////////////////////////////////

class UnlinkDeviceExecutor : public common::AsyncContext
{
public:
    explicit UnlinkDeviceExecutor(common::Cancelable* pCancelable) NN_NOEXCEPT :
        m_pCancelable(pCancelable),
        m_IsAlreadyFailedByInvalidToken(false)
    {
    }

    void SetParameters(ServerDeviceId deviceId, bool isAlwaysClearPairingInfo) NN_NOEXCEPT
    {
        m_DeviceId = deviceId;
        m_IsAlwaysClearPairingInfo = isAlwaysClearPairingInfo;
    }

    virtual void CloseContext() NN_NOEXCEPT NN_OVERRIDE
    {
        delete this;
    }

    virtual nn::Result Execute(common::NetworkBuffer& bufferInfo) NN_NOEXCEPT NN_OVERRIDE;
    virtual void Cancel() NN_NOEXCEPT NN_OVERRIDE;
    virtual bool IsCancelTriggered() const NN_NOEXCEPT NN_OVERRIDE
    {
        return m_pCancelable->IsCanceled();
    }

private:
    nn::Result ExecuteInner(common::NetworkBuffer& bufferInfo) NN_NOEXCEPT;

    common::Cancelable* m_pCancelable;
    ServerDeviceId m_DeviceId;
    bool m_IsAlwaysClearPairingInfo;
    bool m_IsAlreadyFailedByInvalidToken;
};

////////////////////////////////////////////////////////////////////////////////

}}}}}
