﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/pctl/detail/service/common/pctl_AsyncContext.h>
#include <nn/pctl/detail/service/common/pctl_Cancelable.h>
#include <nn/pctl/detail/service/watcher/pctl_ServerResource.h>
#include <nn/pctl/detail/service/watcher/pctl_WatcherData.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

////////////////////////////////////////////////////////////////////////////////

class RetrieveDeviceOwnersExecutor : public common::AsyncContext
{
public:
    explicit RetrieveDeviceOwnersExecutor(common::Cancelable* pCancelable) NN_NOEXCEPT :
        m_pCancelable(pCancelable)
    {
    }

    void SetParameters(size_t* actualOwnerCountPointer, ServerDeviceOwner* pOwners, size_t maxOwnerCount, ServerDeviceId deviceId) NN_NOEXCEPT
    {
        m_ActualOwnerCountPointer = actualOwnerCountPointer;
        m_pOwners = pOwners;
        m_MaxOwnerCount = maxOwnerCount;
        m_DeviceId = deviceId;
    }

    virtual void CloseContext() NN_NOEXCEPT NN_OVERRIDE
    {
        delete this;
    }

    virtual nn::Result Execute(common::NetworkBuffer& bufferInfo) NN_NOEXCEPT NN_OVERRIDE;
    virtual void Cancel() NN_NOEXCEPT NN_OVERRIDE;
    virtual bool IsCancelTriggered() const NN_NOEXCEPT NN_OVERRIDE
    {
        return m_pCancelable->IsCanceled();
    }

private:

    common::Cancelable* m_pCancelable;
    ServerDeviceId m_DeviceId;
    ServerDeviceOwner* m_pOwners;
    size_t m_MaxOwnerCount;
    size_t* m_ActualOwnerCountPointer;
};

////////////////////////////////////////////////////////////////////////////////

}}}}}
