﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/npns/npns_Types.h>
#include <nn/pctl/detail/service/common/pctl_AsyncContext.h>
#include <nn/pctl/detail/service/common/pctl_Cancelable.h>
#include <nn/pctl/detail/service/watcher/pctl_ServerResource.h>
#include <nn/pctl/detail/service/watcher/pctl_WatcherData.h>
#include <nn/pctl/detail/service/watcher/pctl_WatcherEventStorage.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

////////////////////////////////////////////////////////////////////////////////

class UploadDeviceEventsExecutor : public common::AsyncContext
{
public:
    explicit UploadDeviceEventsExecutor(common::Cancelable* pCancelable) NN_NOEXCEPT :
        m_pCancelable(pCancelable),
        m_pEventCount(nullptr),
        m_pEventData(nullptr),
        m_EventDataSize()
    {
    }

    void SetParameters(ServerDeviceId deviceId) NN_NOEXCEPT
    {
        m_DeviceId = deviceId;
    }

    void SetParameters(ServerDeviceId deviceId, size_t* pEventCount, EventData* pEventData, size_t eventDataSize) NN_NOEXCEPT
    {
        SetParameters(deviceId);

        m_pEventCount = pEventCount;
        m_pEventData = pEventData;
        m_EventDataSize = eventDataSize;
    }

    virtual void CloseContext() NN_NOEXCEPT NN_OVERRIDE
    {
        delete this;
    }

    virtual nn::Result Execute(common::NetworkBuffer& bufferInfo) NN_NOEXCEPT NN_OVERRIDE;
    virtual void Cancel() NN_NOEXCEPT NN_OVERRIDE;
    virtual bool IsCancelTriggered() const NN_NOEXCEPT NN_OVERRIDE
    {
        return m_pCancelable->IsCanceled();
    }

public:
    //! @brief デバイスイベントのアップロード処理方法を示す定数です。
    enum UploadMode
    {
        UploadMode_Normal = 0,          //!< 通常アップロード
        UploadMode_PostAllImmediately   //!< 全イベントを即時アップロード(あふれる分をループして再実行する)
    };

    static nn::Result ExecuteUploadDeviceEvents(UploadMode mode, common::NetworkBuffer& bufferInfo,
        ServerDeviceId deviceId, common::Cancelable* pCancelable, EtagInfo* etagBuffer,
        nn::npns::NotificationToken* pNotificationTokenBuffer) NN_NOEXCEPT;

    static nn::Result ExecuteUploadDeviceEvents(size_t* outEventCount, EventData* pOutEventData, size_t eventDataSize,
        UploadMode mode, common::NetworkBuffer& bufferInfo,
        ServerDeviceId deviceId, common::Cancelable* pCancelable, EtagInfo* etagBuffer,
        nn::npns::NotificationToken* pNotificationTokenBuffer) NN_NOEXCEPT;

private:

    common::Cancelable* m_pCancelable;
    ServerDeviceId m_DeviceId;
    EtagInfo m_EtagBuffer;
    nn::npns::NotificationToken m_NotificationTokenBuffer;

    // Event 取得用
    size_t* m_pEventCount;
    EventData* m_pEventData;
    size_t m_EventDataSize;
};

////////////////////////////////////////////////////////////////////////////////

}}}}}
