﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/pctl/detail/service/common/pctl_Cancelable.h>
#include <nn/pctl/detail/service/common/pctl_NetworkBuffer.h>
#include <nn/pctl/detail/service/system/pctl_Settings.h>
#include <nn/pctl/detail/service/watcher/pctl_ServerResource.h>
#include <nn/pctl/detail/service/watcher/pctl_WatcherData.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher { namespace dispatcher {

////////////////////////////////////////////////////////////////////////////////

//! @brief 制限対象外リストを更新した後、ペアコン設定を取得します。
class RequestUpdateExemptionListDispatcher
{
public:
    /**
     * @brief 設定取得を実行します。
     * @param[out] etag ETag値
     * @param[out] outIsNotModified 「Not Modified」のレスポンスだったかどうか
     * @param[in,out] pSettings 現在の設定値を持ち、新しい設定値を受け取るポインター
     * @param[in,out] pFreeCommuncationSettings 現在のアプリケーションごとのUGC制限設定値を持ち、新しい設定値を受け取るポインター
     * @param[in,out] pExemptionSettings 現在のアプリケーションごとの制限対象外設定値を持ち、新しい設定値を受け取るポインター
     * @param[in,out] pPlayTimerSettings 現在のプレイタイマー設定値を持ち、新しい設定値を受け取るポインター
     * @param[in] bufferInfo 通信処理で利用するバッファー
     * @param[in] pCancelable キャンセル処理を行うためのインスタンス
     * @param[in] token デバイストークン文字列
     * @param[in] deviceId 対象のデバイスID
     * @return 処理の結果
     *
     * @details
     * pSettings, pFreeCommuncationSettings, pExemptionSettings, pPlayTimerSettings の各設定値は、
     * メソッド内では初期化を行わず、取得した設定値で対応する構造体の値を上書きします。
     * 必要に応じて呼び出し元で初期化してください。
     */
    static nn::Result Execute(EtagInfo* etag,
        bool* outIsNotModified,
        system::Settings* pSettings,
        system::FreeCommunicationApplicationSettings* pFreeCommuncationSettings,
        system::ExemptApplicationSettings* pExemptionSettings,
        PlayTimerSettings* pPlayTimerSettings,
        common::NetworkBuffer& bufferInfo,
        common::Cancelable* pCancelable,
        const char* token,
        ServerDeviceId deviceId) NN_NOEXCEPT;
};

////////////////////////////////////////////////////////////////////////////////

}}}}}}
