﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/pctl/detail/service/pctl_ServiceConfig.h>
#include <nn/pctl/detail/service/common/pctl_Cancelable.h>
#include <nn/pctl/detail/service/common/pctl_NetworkBuffer.h>
#include <nn/pctl/detail/service/system/pctl_Settings.h>
#include <nn/pctl/detail/service/watcher/pctl_ServerResource.h>
#include <nn/pctl/detail/service/watcher/pctl_WatcherData.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher { namespace dispatcher {

////////////////////////////////////////////////////////////////////////////////

//! @brief 連携コードからデバイスを検索します。
class FindDeviceWithPairingCodeDispatcher
{
public:
    static const size_t MaxPairingCodeLength = service::MaxPairingCodeLength; // NULL文字含まず

    static nn::Result Execute(ServerDeviceSimple& outDevice, common::NetworkBuffer& bufferInfo, common::Cancelable* pCancelable, const char* token, const char (& pairingCode)[MaxPairingCodeLength + 1]) NN_NOEXCEPT;
};

////////////////////////////////////////////////////////////////////////////////

}}}}}}
