﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_StaticAssert.h>

#include <nn/pctl/detail/service/common/pctl_Cancelable.h>
#include <nn/pctl/detail/service/common/pctl_NetworkBuffer.h>
#include <nn/pctl/detail/service/watcher/pctl_ServerResource.h>
#include <nn/pctl/detail/service/watcher/pctl_WatcherData.h>

#include <nn/account/account_TypesForSystemServices.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher { namespace dispatcher {

static const int MaxUidStringLength = 36; // NULL文字込み

int UidToString(char* outString, int maxLengthWithNull, const nn::account::Uid& uid) NN_NOEXCEPT;

/**
 * @brief サーバーに送信するデバイスごとのユーザー情報の更新処理を行います。
 */
class DeviceUserDispatcher
{
public:
    // 追加・更新があったときに実行する処理
    static nn::Result SendPutUser(common::NetworkBuffer& bufferInfo, common::Cancelable* pCancelable,
        const char* token, ServerDeviceId deviceId, const nn::account::Uid& uid) NN_NOEXCEPT;
    // 削除があったときに実行する処理
    static nn::Result SendDeleteUser(common::NetworkBuffer& bufferInfo, common::Cancelable* pCancelable,
        const char* token, ServerDeviceId deviceId, const nn::account::Uid& uid) NN_NOEXCEPT;
};

}}}}}}
