﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace pctl { namespace detail { namespace service {

/**
 * @brief pctlサーバーで利用するメモリを割り当てます。
 */
void* AllocateMemoryBlock(size_t size) NN_NOEXCEPT;

/**
 * @brief pctlサーバーで利用するメモリを割り当てます。
 */
void* AllocateMemoryBlock(size_t size, size_t alignment) NN_NOEXCEPT;

/**
 * @brief pctlサーバーで利用する、指定した型を扱うことができるメモリを割り当てます。
 * @details
 * コンストラクターは呼び出されません。
 */
template <typename T>
inline T* AllocateMemoryBlock() NN_NOEXCEPT
{
    return static_cast<T*>(AllocateMemoryBlock(sizeof(T)));
}

/**
 * @brief pctlサーバーで利用する、指定した型を扱うことができるメモリを割り当てます。
 * @details
 * コンストラクターは呼び出されません。
 */
template <typename T>
inline T* AllocateMemoryBlock(size_t alignment) NN_NOEXCEPT
{
    return static_cast<T*>(AllocateMemoryBlock(sizeof(T), alignment));
}

/**
 * @brief pctlサーバーで利用したメモリを解放します。
 */
void FreeMemoryBlock(void* block) NN_NOEXCEPT;

}}}}
