﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/pctl/detail/service/pctl_ParentalControlStates.h>
#include <nn/pctl/detail/service/system/pctl_SettingsManager.h>
#include <nn/time/time_PosixTime.h>

namespace nn { namespace pctl { namespace detail { namespace service {

class ServiceMain
{
public:
    ServiceMain() NN_NOEXCEPT;

    system::SettingsManager& GetSettingsManager() NN_NOEXCEPT
    {
        return m_SettingsManager;
    }
    const ParentalControlStates& GetStates() NN_NOEXCEPT
    {
        return m_States;
    }
    ParentalControlStates& GetStatesRef() NN_NOEXCEPT
    {
        return m_States;
    }

    void InitializeAndStartThread() NN_NOEXCEPT;

private:
    system::SettingsManager m_SettingsManager;
    ParentalControlStates m_States;
};

/**
 * @brief pctlメイン機能の初期化を行います。
 */
void InitializeMain() NN_NOEXCEPT;
/**
 * @brief pctlメイン機能の終了処理を行います。
 */
void FinalizeMain() NN_NOEXCEPT;

// @brief サービス内で共通のグローバルデータを持つインスタンスです。
extern ServiceMain* g_pMain;

}}}}
