﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/pctl/pctl_TypesSystem.h>
#include <nn/pctl/pctl_TypesWatcher.h>

#include <nn/ovln/format/ovln_PctlMessage.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace overlay {

nn::Result InitializeOverlaySender() NN_NOEXCEPT;
void FinalizeOverlaySender() NN_NOEXCEPT;

// @brief オーバーレイ通知を無効化します。
// @details 無効化された通知の一部は保存され、本体起動時、またはスリープ復帰時に送信されます。
//     既に無効化された状態で呼び出された場合は無視されます(呼び出しのカウントは行いません)。
void DisableOverlayNotification() NN_NOEXCEPT;
// @brief オーバーレイ通知を有効化します。
// @details 無効化中に保存された通知はこのタイミングで送信せず、そのままとします。
//     既に有効化された状態で呼び出された場合は無視されます。また、初期状態は「有効」となります。
void EnableOverlayNotification() NN_NOEXCEPT;

nn::Result NotifySettingChanged(nn::ovln::format::PctlSettingTypeFlagSet settingType) NN_NOEXCEPT;
nn::Result NotifyPlayTimerRemainingTime(int16_t remainingTime, nn::ovln::format::PctlPlayTimerModeFlag mode) NN_NOEXCEPT;
nn::Result NotifyUnlink(nn::ovln::format::PctlUnlinkReasonFlag reason) NN_NOEXCEPT;
nn::Result NotifyTimeExceededOnStart(int64_t exceedingTime, nn::ovln::format::PctlPlayTimerModeFlag mode) NN_NOEXCEPT;
nn::Result NotifyAlarmSettingChanged(nn::ovln::format::PctlAlarmSettingFlag flag) NN_NOEXCEPT;

inline nn::ovln::format::PctlPlayTimerModeFlag ConvertModeFlag(PlayTimerMode mode) NN_NOEXCEPT
{
    NN_STATIC_ASSERT(
        static_cast<int>(nn::ovln::format::PctlPlayTimerModeFlag::PctlPlayTimerModeFlag_Alarm) == static_cast<int>(PlayTimerMode::PlayTimerMode_Alarm)
    );
    NN_STATIC_ASSERT(
        static_cast<int>(nn::ovln::format::PctlPlayTimerModeFlag::PctlPlayTimerModeFlag_Suspend) == static_cast<int>(PlayTimerMode::PlayTimerMode_Suspend)
    );
    return static_cast<nn::ovln::format::PctlPlayTimerModeFlag>(mode);
}

}}}}}
