﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/pctl/detail/service/common/pctl_HttpRequest.h>
#include <nn/pctl/detail/service/json/pctl_JsonInputStream.h>
#include <nn/nn_Result.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace json {

/*!
    @brief      HTTP 通信でサーバーからデータを読み込む入力ストリームです。
                common::HttpRequest を利用します。
*/
class JsonHttpInputStream : public JsonInputStream
{
public:
    typedef JsonInputStream::Ch Ch;

public:
    /*!
        @brief      コンストラクタです。
    */
    JsonHttpInputStream() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    virtual ~JsonHttpInputStream() NN_NOEXCEPT;

    /*!
        @brief      HttpRequest のインスタンスを取得します。
    */
    common::HttpRequest& GetRequest() NN_NOEXCEPT
    {
        return m_Request;
    }

    /*!
        @brief      キャンセル可能オブジェクトを設定します。

        @param[in]  cancelable  キャンセル可能オブジェクト。

        @details
                    キャンセル可能オブジェクトを設定することで、入力処理を中断することが可能です。
    */
    void SetCancelable(const common::Cancelable* cancelable) NN_NOEXCEPT
    {
        m_Request.SetCancelable(cancelable);
        JsonInputStream::SetCancelable(cancelable);
    }

protected:
    //
    virtual nn::Result FillImpl(size_t* outRead, void* buffer, size_t bufferSize) NN_NOEXCEPT NN_OVERRIDE;

private:
    common::HttpRequest m_Request;
};

}}}}}
