﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/pctl/detail/service/json/pctl_JsonInputStream.h>
#include <nn/fs.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace json {

/*!
    @brief      ファイルからデータを読み込む入力ストリームです。
*/
class JsonFileInputStream : public JsonInputStream
{
public:
    typedef JsonInputStream::Ch Ch;

public:
    /*!
        @brief      コンストラクタです。
    */
    JsonFileInputStream() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    virtual ~JsonFileInputStream() NN_NOEXCEPT;

    /*!
        @brief      入力ストリームを開きます。

        @param[in]  path    ファイルパス。

        @pre
            - path != nullptr

        @return     処理結果。
    */
    nn::Result Open(const char* path) NN_NOEXCEPT;

    /*!
        @brief      入力ストリームを閉じます。
    */
    void Close() NN_NOEXCEPT;

protected:
    //
    virtual nn::Result FillImpl(size_t* outRead, void* buffer, size_t bufferSize) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::fs::FileHandle m_Handle;
    //
    bool m_IsOpened;
    //
    int64_t m_Position;
};

}}}}}
