﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace common {

// @brief 既定のレーティング団体の決定に用いるリージョンの定数です。必要最低限のリージョンのみ列挙しています。
enum class RegionForDefaultRatingOrganization
{
    Others = 0,
    Japan,
    NorthAmerica,
    Europe,
    Australia,
    Max
};

// @brief 既定のレーティング団体の決定に用いる言語の定数です。必要最低限の言語のみ列挙しています。
enum class LanguageForDefaultRatingOrganization
{
    Others = 0, // 割り当て済みの言語に当てはまらない場合に利用
    English,
    French,
    Spanish,
    Italian,
    Dutch,
    Japanese,
    German,
    Portuguese,
    Russian,
    TraditionalChinese,
    SimplifiedChinese,
    Korean,
    Max
};

// @brief システムバージョン表記文字列の最大長
static const size_t MaxSystemVersionStringLength = 24;

}}}}}
