﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace common {

/**
 * @brief 通信処理で利用するバッファーデータの定義
 */
struct NetworkBuffer
{
    static const size_t JsonValueBufferMemorySize = 4096;
    static const size_t StreamBufferMemorySize = 1024;
    static const size_t EntireBufferMemorySize = JsonValueBufferMemorySize + StreamBufferMemorySize;

    // @brief JSON解析用のバッファーを返します。
    uint8_t* GetBufferForJsonValue()
    {
        return _value;
    }

    // @brief データ取得用のバッファーを返します。
    uint8_t* GetBufferForStream()
    {
        NN_STATIC_ASSERT((std::extent<decltype(_value)>::value - JsonValueBufferMemorySize) == StreamBufferMemorySize);
        return _value + JsonValueBufferMemorySize;
    }

    // @brief バッファー全体を返します。(GetBufferForJsonValue() と GetBufferForJsonValue() がつながったものになります。)
    uint8_t* GetEntireBuffer()
    {
        return _value;
    }

    uint8_t _value[EntireBufferMemorySize];
};

}}}}}
