﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/pctl/pctl_TypesSystem.h>
#include <nn/pctl/detail/service/common/pctl_SystemInfoTypes.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace common {

static const size_t DefaultRatingOrganizationsCount =
    static_cast<size_t>(RegionForDefaultRatingOrganization::Max) * static_cast<size_t>(LanguageForDefaultRatingOrganization::Max);

extern const SafetyLevelSettings SafetyLevelPresetSettings[SafetyLevel::SafetyLevel_Max];
// 日本のみ異なる値があるので別定義
extern const SafetyLevelSettings SafetyLevelPresetSettingsForJapan[SafetyLevel::SafetyLevel_Max];
extern const nn::ns::RatingOrganization DefaultRatingOrganizations[];

}}}}}
