﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_StaticAssert.h>
#include <nn/pctl/pctl_PairingInfo.h>

namespace nn { namespace pctl { namespace detail {

/**
 * @brief 元のクラスと同じサイズのクラスに変換するためのクラスの紐付けを行うテンプレートクラスです。
 * @tparam TSource 変換元のクラス
 */
template <class TSource>
class ToHolderClass
{
    // 特殊化したクラスで以下を定義
    // typedef HolderClass Type;
};

/**
 * @brief 特定のクラスを Holder クラスに変換します。
 */
template <class TSource>
inline typename ToHolderClass<TSource>::Type* ToHolder(TSource* p) NN_NOEXCEPT
{
    // 簡単のためここで判定
    NN_STATIC_ASSERT(sizeof(TSource) == sizeof(typename ToHolderClass<TSource>::Type));
    return reinterpret_cast<typename ToHolderClass<TSource>::Type*>(p);
}
/**
 * @brief 特定のクラスを Holder クラスに変換します。
 */
template <class TSource>
inline const typename ToHolderClass<TSource>::Type* ToHolder(const TSource* p) NN_NOEXCEPT
    { return reinterpret_cast<const typename ToHolderClass<TSource>::Type*>(p); }

struct PairingAccountInfoBase
{
    uint64_t id;
    uint8_t padding[8];
};

class PairingAccountInfoHolder : public PairingAccountInfoBase
{
public:
    void Initialize() NN_NOEXCEPT
    {
        this->id = 0;
    }

    bool IsValid() const NN_NOEXCEPT
    {
        return id != 0;
    }

    void Invalidate() NN_NOEXCEPT
    {
        this->id = 0;
    }
};

template <>
class ToHolderClass<PairingAccountInfo>
{
public:
    typedef PairingAccountInfoHolder Type;
};

struct PairingInfoBase
{
    uint64_t id;
    int32_t state;
    uint8_t padding[4];
};

class PairingInfoHolder : public PairingInfoBase
{
public:
    void Initialize() NN_NOEXCEPT
    {
        id = 0;
    }

    bool IsValid() const NN_NOEXCEPT
    {
        return id != 0;
    }

    void Invalidate() NN_NOEXCEPT
    {
        id = 0;
    }
};

template <>
class ToHolderClass<PairingInfo>
{
public:
    typedef PairingInfoHolder Type;
};

}}}
