﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/http/http_Result.h>
#include <nn/npns/npns_Result.h>
#include <nn/pctl/pctl_ResultPrivate.h>
#include <nn/pctl/detail/pctl_NpnsErrorHandler.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace pctl { namespace detail {

inline bool IsAcceptableNpnsResultImpl(nn::Result result) NN_NOEXCEPT
{
    if (result.IsSuccess())
    {
        return true;
    }
    NN_RESULT_TRY(result)
        NN_RESULT_CATCH(nn::npns::ResultOutOfMemory)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultInsufficientBuffer)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultNotReceived)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultAlreadyRegistered)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultSizeLimitExceeded)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultUnknownVersion)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultAlreadyInitialized)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultConnectionFailed)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultConnectionTimeOut)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultNotConnected)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultPermissionDenied)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultCommandTimeOut)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultTopicNotSubscribed)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultTopicNotFound)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultAccountNotAvailable)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultAccountAvailable)
        {
            return true;
        }

        // StateMachine
        NN_RESULT_CATCH(nn::npns::ResultInterruptByRequest)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultCanceledByOtherRequest)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultProcessingPriorityRequest)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultInErrorState)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultDisconnected)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultCanceledByHardwareEvents)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultCanceledByUserRequest)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultInvalidOperation)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultOperationDenied)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultAuthenticationFailed)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultConnectionAborted)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultConnectionReset)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::npns::ResultNetworkIsNotAvailable)
        {
            return true;
        }

        // XMPP
        NN_RESULT_CATCH(nn::npns::ResultXmppError)
        {
            return true;
        }

        // REST
        NN_RESULT_CATCH(nn::npns::ResultRestError)
        {
            return true;
        }

        // nn::http (※ 一部のみ)
        NN_RESULT_CATCH(nn::http::ResultNotConnected)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::http::ResultCancelled)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::http::ResultJsonParseError)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::http::ResultHttpStatus)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::http::ResultCurlOutOfMemory)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::http::ResultCurlError)
        {
            return true;
        }
        NN_RESULT_CATCH(nn::http::ResultCurlMultiError)
        {
            return true;
        }

        NN_RESULT_CATCH_ALL
        {
            return false;
        }
    NN_RESULT_END_TRY

    // unreachable
    return false;
} // NOLINT(impl/function_size)

inline nn::Result ConvertNpnsErrorImpl(nn::Result result) NN_NOEXCEPT
{
    if (result.IsSuccess())
    {
        return result;
    }
    if (IsAcceptableNpnsResult(result))
    {
        return result;
    }

    // (変換可能なResultはここで変換する)

    NN_RESULT_THROW(nn::pctl::ResultUnknownNpnsError());
}

}}}
