﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace pctl { namespace detail {

//! @brief npnsで発生した、ハンドリング可能なResultかどうかを返します。
//! @details true である場合、呼び出し元にそのまま返すかエラービューアアプレット表示を行います。
bool IsAcceptableNpnsResult(nn::Result result) NN_NOEXCEPT;
//! @brief npnsで発生したResultを必要に応じて変換します。
//! @details IsAcceptableNpnsResult(result) が true である場合は result が変換されずに返ります。
nn::Result ConvertNpnsError(nn::Result result) NN_NOEXCEPT;

// ※上記関数は himライブラリ側は pctl_ResultHandler.cpp (Shimライブラリ)で、
// サービス側は pctl_NpnsErrorHandlerForService.cpp (プロセス内)に実体を定義
// (ただしそれぞれの中身は ―Impl としてこのヘッダーファイルで inline で定義)

}}}
