﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      pctl モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_PCTL_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCTL_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCTL_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCTL_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCTL_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCTL_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCTL_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCTL_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCTL_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCTL_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCTL_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCTL_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCTL_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCTL_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCTL_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCTL_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCTL_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCTL_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCTL_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCTL_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pctl, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCTL_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Trace, 0, format, args)
#define NN_DETAIL_PCTL_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Trace, 1, format, args)
#define NN_DETAIL_PCTL_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Trace, 2, format, args)
#define NN_DETAIL_PCTL_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Trace, 3, format, args)

#define NN_DETAIL_PCTL_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Info, 0, format, args)
#define NN_DETAIL_PCTL_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Info, 1, format, args)
#define NN_DETAIL_PCTL_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Info, 2, format, args)
#define NN_DETAIL_PCTL_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Info, 3, format, args)

#define NN_DETAIL_PCTL_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Warn, 0, format, args)
#define NN_DETAIL_PCTL_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Warn, 1, format, args)
#define NN_DETAIL_PCTL_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Warn, 2, format, args)
#define NN_DETAIL_PCTL_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Warn, 3, format, args)

#define NN_DETAIL_PCTL_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Error, 0, format, args)
#define NN_DETAIL_PCTL_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Error, 1, format, args)
#define NN_DETAIL_PCTL_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Error, 2, format, args)
#define NN_DETAIL_PCTL_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Error, 3, format, args)

#define NN_DETAIL_PCTL_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Fatal, 0, format, args)
#define NN_DETAIL_PCTL_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Fatal, 1, format, args)
#define NN_DETAIL_PCTL_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Fatal, 2, format, args)
#define NN_DETAIL_PCTL_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pctl, Fatal, 3, format, args)

#define NN_DETAIL_PCTL_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Trace, 0, text, length)
#define NN_DETAIL_PCTL_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Trace, 1, text, length)
#define NN_DETAIL_PCTL_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Trace, 2, text, length)
#define NN_DETAIL_PCTL_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Trace, 3, text, length)

#define NN_DETAIL_PCTL_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Info, 0, text, length)
#define NN_DETAIL_PCTL_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Info, 1, text, length)
#define NN_DETAIL_PCTL_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Info, 2, text, length)
#define NN_DETAIL_PCTL_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Info, 3, text, length)

#define NN_DETAIL_PCTL_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Warn, 0, text, length)
#define NN_DETAIL_PCTL_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Warn, 1, text, length)
#define NN_DETAIL_PCTL_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Warn, 2, text, length)
#define NN_DETAIL_PCTL_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Warn, 3, text, length)

#define NN_DETAIL_PCTL_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Error, 0, text, length)
#define NN_DETAIL_PCTL_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Error, 1, text, length)
#define NN_DETAIL_PCTL_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Error, 2, text, length)
#define NN_DETAIL_PCTL_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Error, 3, text, length)

#define NN_DETAIL_PCTL_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Fatal, 0, text, length)
#define NN_DETAIL_PCTL_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Fatal, 1, text, length)
#define NN_DETAIL_PCTL_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Fatal, 2, text, length)
#define NN_DETAIL_PCTL_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pctl, Fatal, 3, text, length)
