﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   PCM ライブラリのチャンネルアクセス機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/pcm/pcm_MeasuringPoint.h>

namespace nn {
namespace pcm {

//! @name 電圧の取得
//! @{

  /**
 * @brief 指定したポイントでの直近の電圧を計測デバイスから読み出し mV 単位で取得します。
 *
 * @param[in]  point      電力計測ポイント識別子
 *
 * @return  電圧 [mV]
 *
 * @pre
 *  - ライブラリが初期化済の状態である
 *
 * @details
 *  指定したポイントでの直近の電圧を mV 単位で取得します。@n
 *  指定した電力計測ポイントが利用可能でない場合、常に 0 を返します。@n
 *  電力計測ポイントが利用可能かどうかの判定には @ref nn::pcm::IsSupported() を使用してください。@n
 *  関数内で計測デバイスへのアクセスを行うため、本関数は最大数 msec ブロックする可能性があります。
 */
int ReadCurrentVoltage(MeasuringPoint point) NN_NOEXCEPT;

//! @}
// ~電圧の取得

} // pcm
} // nn


