﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      omm モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_OMM_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(omm, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_OMM_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(omm, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_OMM_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(omm, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_OMM_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(omm, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_OMM_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(omm, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_OMM_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(omm, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_OMM_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(omm, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_OMM_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(omm, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_OMM_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(omm, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_OMM_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(omm, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_OMM_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(omm, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_OMM_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(omm, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_OMM_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(omm, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_OMM_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(omm, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_OMM_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(omm, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_OMM_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(omm, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_OMM_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(omm, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_OMM_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(omm, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_OMM_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(omm, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_OMM_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(omm, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_OMM_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Trace, 0, format, args)
#define NN_DETAIL_OMM_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Trace, 1, format, args)
#define NN_DETAIL_OMM_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Trace, 2, format, args)
#define NN_DETAIL_OMM_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Trace, 3, format, args)

#define NN_DETAIL_OMM_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Info, 0, format, args)
#define NN_DETAIL_OMM_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Info, 1, format, args)
#define NN_DETAIL_OMM_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Info, 2, format, args)
#define NN_DETAIL_OMM_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Info, 3, format, args)

#define NN_DETAIL_OMM_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Warn, 0, format, args)
#define NN_DETAIL_OMM_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Warn, 1, format, args)
#define NN_DETAIL_OMM_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Warn, 2, format, args)
#define NN_DETAIL_OMM_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Warn, 3, format, args)

#define NN_DETAIL_OMM_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Error, 0, format, args)
#define NN_DETAIL_OMM_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Error, 1, format, args)
#define NN_DETAIL_OMM_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Error, 2, format, args)
#define NN_DETAIL_OMM_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Error, 3, format, args)

#define NN_DETAIL_OMM_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Fatal, 0, format, args)
#define NN_DETAIL_OMM_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Fatal, 1, format, args)
#define NN_DETAIL_OMM_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Fatal, 2, format, args)
#define NN_DETAIL_OMM_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(omm, Fatal, 3, format, args)

#define NN_DETAIL_OMM_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(omm, Trace, 0, text, length)
#define NN_DETAIL_OMM_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(omm, Trace, 1, text, length)
#define NN_DETAIL_OMM_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(omm, Trace, 2, text, length)
#define NN_DETAIL_OMM_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(omm, Trace, 3, text, length)

#define NN_DETAIL_OMM_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(omm, Info, 0, text, length)
#define NN_DETAIL_OMM_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(omm, Info, 1, text, length)
#define NN_DETAIL_OMM_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(omm, Info, 2, text, length)
#define NN_DETAIL_OMM_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(omm, Info, 3, text, length)

#define NN_DETAIL_OMM_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(omm, Warn, 0, text, length)
#define NN_DETAIL_OMM_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(omm, Warn, 1, text, length)
#define NN_DETAIL_OMM_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(omm, Warn, 2, text, length)
#define NN_DETAIL_OMM_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(omm, Warn, 3, text, length)

#define NN_DETAIL_OMM_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(omm, Error, 0, text, length)
#define NN_DETAIL_OMM_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(omm, Error, 1, text, length)
#define NN_DETAIL_OMM_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(omm, Error, 2, text, length)
#define NN_DETAIL_OMM_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(omm, Error, 3, text, length)

#define NN_DETAIL_OMM_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(omm, Fatal, 0, text, length)
#define NN_DETAIL_OMM_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(omm, Fatal, 1, text, length)
#define NN_DETAIL_OMM_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(omm, Fatal, 2, text, length)
#define NN_DETAIL_OMM_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(omm, Fatal, 3, text, length)
