﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Types.h>
#include <nn/nn_ApplicationId.h>
#include <nn/olsc/olsc_DataTypes.h>
#include <nn/olsc/srv/olsc_InternalTypes.h>
#include <nn/olsc/srv/olsc_SaveDataArchiveInfoCacheManager.h>
#include <nn/olsc/srv/olsc_SeriesInfoDatabaseManager.h>

namespace nn { namespace olsc { namespace srv { namespace util {

DataNewness ConvertToDataNewness(SeriesPosition seriesPosition) NN_NOEXCEPT;

/* サーバーとローカルの両方の情報がわかる場合に使う */
SeriesPosition CalculateSeriesPosition(
    const SeriesInfo& lastSi,
    const nn::util::optional<fs::SaveDataCommitId>& pCurrentCommitId,
    const nn::util::optional<SaveDataArchiveInfo>& pCachedSda) NN_NOEXCEPT;

/* サーバーの情報だけがわかる場合に使う */
Result EvaluateSaveDataInfoCacheSeriesInfo(
    SeriesPosition* pOut,
    const account::Uid& uid,
    const SaveDataArchiveInfo& cachedSda,
    const database::SeriesInfoDatabase& seriesInfoDatabase) NN_NOEXCEPT;

}}}} // nn::olsc::srv::util
